package civvi.osgi.desktop.component.view;

import java.awt.BorderLayout;
import java.util.Map.Entry;

import javax.swing.JScrollPane;

import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.JXPanel;
import org.osgi.framework.ServiceReference;

import civvi.osgi.desktop.DesktopService;
import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.AppFrameworkSupport;
import civvi.osgi.desktop.swingx.GenericListModel;
import civvi.osgi.desktop.swingx.SwingUtil;
import civvi.osgi.desktop.view.AbstractEditorView;
import civvi.osgi.desktop.view.AbstractView;

/**
 * A panel for displaying all the available views.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [11 Jul 2010]
 */
public class OtherViewPane extends JXPanel {
	private static final long serialVersionUID = 1L;

	private final AppFrameworkSupport<OSGiDesktop> support;
	private final JXList list;

	private final GenericListModel<Class<? extends AbstractView>> model;

	/**
	 * 
	 * TODO
	 * @param desktop
	 */
	public OtherViewPane(OSGiDesktop desktop) {
		super(new BorderLayout());
		support = new AppFrameworkSupport<OSGiDesktop>(this);

		final JXHeader header = new JXHeader(
				this.support.getString("title"),
				this.support.getString("description"),
				this.support.getIcon("icon"));

		add(SwingUtil.wrap(header), BorderLayout.NORTH);
		add(new JScrollPane(this.list = new JXList()), BorderLayout.CENTER);
		this.list.setModel(this.model = new GenericListModel<Class<? extends AbstractView>>());
		this.list.setCellRenderer(new BeanInfoCellRenderer());

		for (Entry<ServiceReference, DesktopService<?>> entry : 
			desktop.getActivator().getServiceManager().getAll().entrySet())
		{
			for (Class<? extends AbstractView> viewType : entry.getValue().getViews()) {
				if (!AbstractEditorView.class.isAssignableFrom(viewType)) {
					this.model.add(viewType);
				}
			}
		}
	}

	/**
	 * 
	 * TODO
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public Class<? extends AbstractView> getSelected() {
		return (Class<? extends AbstractView>) this.list.getSelectedValue();
	}
}
