package civvi.osgi.desktop.editor;

import java.awt.Component;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;

import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 14 Apr 2009
 */
public class EditableCellRenderer extends DefaultListCellRenderer {
	private static final long serialVersionUID = -2795399804707241894L;

	/**
	 * {@inheritDoc}
	 */
	@Override
	@SuppressWarnings("unchecked")
	public final Component getListCellRendererComponent(
			JList list,
			Object value,
			int index,
			boolean isSelected,
			boolean cellHasFocus)
	{
		super.getListCellRendererComponent(
				list,
				value,
				index,
				isSelected,
				cellHasFocus);
		decorate((Class<? extends Editable>) value);
		return this;
	}

	/**
	 * 
	 * TODO
	 *
	 * @param value
	 */
	private void decorate(Class<? extends Editable> value) {
		final BeanInfo beanInfo;
		try {
			beanInfo = Introspector.getBeanInfo(value);
		} catch (IntrospectionException ie) {
			setIcon(null);
			setToolTipText(null);
			setText("Unable to locate Bean Info: " + value.getClass());
			return;
		}
		
		setIcon(new ImageIcon(beanInfo.getIcon(BeanInfo.ICON_COLOR_16x16)));
		setText(beanInfo.getBeanDescriptor().getDisplayName());
		setToolTipText(beanInfo.getBeanDescriptor().getShortDescription());
	}
}
