package civvi.osgi.desktop.help;

import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

import civvi.osgi.desktop.DesktopRuntimeException;

/**
 * 
 * TODO
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 Jun 2010]
 */
public interface HelpProvider {
	/**
	 * @param pathUri the path uri. We expect that the uri will start with
	 * {@code help:}.
	 */
	void show(String pathUri);


	// --- Inner Classes ---

	/**
	 * A very basic provider that simply shows the wiki-page on GoogleCode.
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since v1.0.0 [14 Jun 2010]
	 */
	public static class DefaultHelpProvider implements HelpProvider {
		@Override
		public void show(String pathUri) {
			if (pathUri == null || !pathUri.startsWith("help:")) {
				throw new DesktopRuntimeException(
						"Path does not start with 'help:'! [" + pathUri + "]");
			}

			pathUri = pathUri.replace("help:", "http://code.google.com/p/osgi-desktop/w/list");

			try {
				Desktop.getDesktop().browse(new URI(pathUri));
			} catch (URISyntaxException use) {
				throw new DesktopRuntimeException(
						"Unable to parse URI! [" + pathUri + "]",
						use);
			} catch (IOException ioe) {
				throw new DesktopRuntimeException(
						"Failed to launch browser for URI! [" + pathUri + "]",
						ioe);
			}
		}
	}
}
