package civvi.osgi.desktop.help;

/**
 * Manages the help providers. In most circumstances this would be HTML data.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 Jun 2010]
 */
public class HelpProviderManager {
	private static volatile HelpProviderManager INSTANCE;
	private final HelpProvider provider;

	/**
	 * 
	 * TODO
	 */
	private HelpProviderManager() {
		// FIXME make this pluggable
		this.provider = new HelpProvider.DefaultHelpProvider();
	}

	/**
	 * 
	 * TODO
	 * @param pathUri
	 */
	public static void show(String pathUri) {
		getInstance().provider.show(pathUri);
	}

	/**
	 * 
	 * TODO
	 * @return
	 */
	private static HelpProviderManager getInstance() {
		if (INSTANCE == null) {
			synchronized (HelpProviderManager.class) {
				if (INSTANCE == null) {
					INSTANCE = new HelpProviderManager();

				}
			}
		}
		return INSTANCE;
	}
}
