package civvi.osgi.desktop.log;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;

/**
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [24 Sep 2010]
 */
public class DesktopLogEntry implements LogEntry {
	private final Bundle bundle;
	private final ServiceReference ref;
	private final int level;
	private final String message;
	private final Throwable t;
	private final long time;

	/**
	 * 
	 * @param bundle
	 * @param ref
	 * @param level
	 * @param message
	 * @param t
	 */
	public DesktopLogEntry(
			Bundle bundle,
			ServiceReference ref,
			int level,
			String message,
			Throwable t)
	{
		this(bundle, ref, level, message, t, System.currentTimeMillis());
	}

	/**
	 * 
	 * @param bundle
	 * @param ref
	 * @param level
	 * @param message
	 * @param t
	 * @param time
	 */
	public DesktopLogEntry(
			Bundle bundle,
			ServiceReference ref,
			int level,
			String message,
			Throwable t,
			long time)
	{
		this.bundle = bundle;
		this.ref = ref;
		this.level = level;
		this.message = message;
		this.t = t;
		this.time = time;
	}

	@Override
	public Bundle getBundle() {
		return this.bundle;
	}

	@Override
	public ServiceReference getServiceReference() {
		return this.ref;
	}

	@Override
	public int getLevel() {
		return this.level;
	}

	@Override
	public String getMessage() {
		return this.message;
	}

	@Override
	public Throwable getException() {
		return this.t;
	}

	@Override
	public long getTime() {
		return this.time;
	}
}
