package civvi.osgi.desktop.log;

import static java.util.logging.Level.FINE;
import static java.util.logging.Level.INFO;
import static java.util.logging.Level.SEVERE;
import static java.util.logging.Level.WARNING;
import static org.osgi.service.log.LogService.LOG_DEBUG;
import static org.osgi.service.log.LogService.LOG_ERROR;
import static org.osgi.service.log.LogService.LOG_INFO;
import static org.osgi.service.log.LogService.LOG_WARNING;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

import org.osgi.framework.Bundle;

/**
 * A basic JDK logger implementation that uses the
 * {@link Logger#getAnonymousLogger()} for it's instance. 
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [28 Sep 2010]
 */
public class DesktopLogHandler extends Handler {
	private final Bundle bundle;
	private final DesktopLogReaderService readerService;

	/**
	 * 
	 * @param readerService
	 */
	public DesktopLogHandler(Bundle bundle, DesktopLogReaderService readerService) {
		this.bundle = bundle;
		this.readerService = readerService;
	}

	@Override
	public void publish(LogRecord record) {
		final DesktopLogEntry entry = new DesktopLogEntry(
				this.bundle,
				null,
				toLevel(record.getLevel()),
				record.getMessage(),
				record.getThrown());
		this.readerService.add(entry);
	}

	@Override
	public void flush() { }

	@Override
	public void close() throws SecurityException { }


	// --- Static Methods ---

	/**
	 * 
	 * @param level
	 * @return
	 */
	private static int toLevel(Level level) {
		if (level.intValue() <= SEVERE.intValue() &&
				level.intValue() > WARNING.intValue())
		{
			return LOG_ERROR;
		}
		if (level.intValue() <= WARNING.intValue() &&
				level.intValue() > INFO.intValue())
		{
			return LOG_WARNING;
		} 
		if (level.intValue() <= INFO.intValue() &&
				level.intValue() > FINE.intValue())
		{
			return LOG_INFO;
		}
		if (level.intValue() <= FINE.intValue() &&
				level.intValue() > 0)
		{
			return LOG_DEBUG;
		}
		return -1;
	}
}
