package civvi.osgi.desktop.log;

import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogService;

/**
 * A OSGi Desktop {@link LogService} to track logging messages.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [24 Sep 2010]
 */
public class DesktopLogService implements LogService {
	private final Bundle bundle;
	private final DesktopLogReaderService readerService;
	
	/**
	 * 
	 * @param bundle
	 * @param readerService
	 */
	public DesktopLogService(
			Bundle bundle,
			DesktopLogReaderService readerService)
	{
		this.bundle = bundle;
		this.readerService = readerService;
	}

	@Override
	public void log(int level, String message) {
		log(null, level, message, null);
	}

	@Override
	public void log(int level, String message, Throwable t) {
		log(null, level, message, t);
	}

	@Override
	public void log(ServiceReference ref, int level, String message) {
		log(ref, level, message, null);
	}

	@Override
	public void log(
			ServiceReference sr,
			int level,
			String message,
			Throwable exception)
	{
		final LogEntry entry = new DesktopLogEntry(
				this.bundle, sr, level, message, exception);
		this.readerService.add(entry);
	}
}
