package civvi.osgi.desktop.perspective;


import civvi.osgi.desktop.ViewManager;
import civvi.osgi.desktop.swingx.docking.DockManager;
import civvi.osgi.desktop.swingx.docking.perspective.Perspective;
import civvi.osgi.desktop.swingx.docking.perspective.PerspectiveFactory;
import civvi.osgi.desktop.swingx.docking.perspective.PerspectiveLeaf;
import civvi.osgi.desktop.swingx.docking.perspective.PerspectiveView;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 24th July 2008
 */
public class DesktopPerspectiveFactory implements PerspectiveFactory {
	/**
	 * {@inheritDoc}
	 */
	@Override
	public Perspective create(DockManager manager, String key) {
		if (!ViewManager.DEFAULT_PERSPECTIVE.equals(key)) {
			throw new UnsupportedOperationException("Only default perspective supported!");
		}

		final Perspective perspective = new Perspective(ViewManager.DEFAULT_PERSPECTIVE);
		perspective.setLayout("(COLUMN (LEAF name=default weight=0.75) (LEAF name=south weight=0.25))");
		final PerspectiveLeaf defaultNode = new PerspectiveLeaf("default");
		defaultNode.getViews().add(
				new PerspectiveView("default"));
//		defaultNode.getViews().add(
//				new PerspectiveView("tail"));
		perspective.getLeafs().add(defaultNode);
		
		final PerspectiveLeaf southNode = new PerspectiveLeaf("south");
		southNode.getViews().add(
				new PerspectiveView("properties"));
		southNode.getViews().add(
				new PerspectiveView("tasks"));
		perspective.getLeafs().add(southNode);
		return perspective;
	}
}
