package civvi.osgi.desktop.preferences;

import java.awt.BorderLayout;
import java.util.prefs.Preferences;

import org.jdesktop.application.Application;
import org.jdesktop.swingx.JXPanel;

import civvi.osgi.desktop.swingx.AppFrameworkSupport;

/**
 * Defines a panel within the {@link PreferencesEditor}.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [24th July 2008]
 */
public abstract class AbstractPreferencePane extends JXPanel {
	private static final long serialVersionUID = -7976646150162174961L;

	protected final AppFrameworkSupport<Application<?>> support;

	/**
	 * Default constructor.
	 */
	public AbstractPreferencePane() {
		super(new BorderLayout());
		this.support = new AppFrameworkSupport<Application<?>>(this);
	}

	/**
	 * 
	 * @param preferences
	 */
	protected abstract void load(Preferences preferences);

	/**
	 * 
	 * @param preferences
	 */
	protected abstract void save(Preferences preferences);
}
