package civvi.osgi.desktop.preferences;

import java.util.prefs.Preferences;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;

/**
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [24th July 2008]
 */
public class DefaultPreferencesPane extends AbstractPreferencePane {
	private static final long serialVersionUID = 2342950590839833618L;
	
	private final JCheckBox confirmOnExitCheck;

	public DefaultPreferencesPane() {

		final JPanel panel = new JPanel();
		final FormLayout formlayout1 = new FormLayout(
				"FILL:DEFAULT:GROW(1.0)",
				"CENTER:DEFAULT:NONE");
		formlayout1.setColumnGroups(new int[][]{ {1} });
		CellConstraints cc = new CellConstraints();
		panel.setLayout(formlayout1);

		this.confirmOnExitCheck = new JCheckBox(this.support.getString("confirmOnExit.check.text"));
		panel.add(this.confirmOnExitCheck,cc.xy(1,1));

		add(panel);
	}

	@Override
	protected void load(Preferences preferences) {
		this.confirmOnExitCheck.setSelected(preferences.getBoolean(
				DefaultPreference.CONFIRM_ON_EXIT.name(),
				true));
	}

	@Override
	protected void save(Preferences preferences) {
		preferences.putBoolean(
				DefaultPreference.CONFIRM_ON_EXIT.name(),
				this.confirmOnExitCheck.isSelected());
	}
}
