package civvi.osgi.desktop.swingx;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.jdesktop.application.Application;
import org.jdesktop.application.Task;

/**
 * A {@link Task} which implements a common way of performing GUI error
 * handling.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [30 Apr 2010]
 * @param <T>
 * @param <V>
 */
public abstract class AbstractTask<T, V> extends Task<T, V>{
	protected final Logger log = Logger.getLogger(getClass().getName());

	private final Level errorLevel;

	/**
	 * Default task constructor displaying errors at {@link Level#WARNING}.
	 */
	public AbstractTask() {
		this(Level.WARNING);
	}

	/**
	 * Constructs a task that has a choice of error message level.
	 *
	 * @param errorLevel
	 */
	public AbstractTask(Level errorLevel) {
		super(Application.getContext().getApplication());
		this.errorLevel = errorLevel;
	}

	@Override
	protected void failed(Throwable cause) {
		if (log.isLoggable(this.errorLevel)) {
			log.log(this.errorLevel, cause.getLocalizedMessage(), cause);
		}

		SwingUtil.showErrorDialog(
				(Component) getApplication().getMainTopLevel(),
				getResourceMap().getString("error.title"),
				getResourceMap().getString("error.message"),
				this.errorLevel.getLocalizedName(),
				cause,
				this.errorLevel);
	}
}
