package civvi.osgi.desktop.swingx;

import javax.swing.Action;

/**
 * Defines a class that can supply actions.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 Jun 2010]
 */
public interface ActionProvider {
	/**
	 * Returns an action for the given key.
	 * 
	 * @param actionKey the action key.
	 * @param allowCreateEmpty if {@code true} if no action is found for the
	 * key a new empty one will be created. This is useful when creating menu
	 * bars where sub-menus are utilised.
	 * @return the found action.
	 */
	Action getAction(String actionKey, boolean allowCreateEmpty);
}
