package civvi.osgi.desktop.swingx;

import java.util.logging.Level;

/**
 * A cheaky class to allow manipulation of the progress but the promoting
 * decoupling of Swing and business activities. This class should be used
 * inplace of {@link application.Task} if progress information is required to
 * be passed from the business method. The business method should always be
 * able to run without a {@link Progress}.
 * <p/>
 * 
 * TODO dan.siviter: this is by no means perfect as a intermediate class is
 * required that is not in the UI package structure. Time for a think,
 * methinks!
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 3rd Nov 2006
 */
public abstract class BusinessTask<T, V> extends AbstractTask<T, V> {
	/**
	 * 
	 * TODO
	 */
	public BusinessTask() {
		super();
	}
	
	/**
	 * 
	 * TODO
	 * @param errorLevel
	 */
	public BusinessTask(Level errorLevel) {
		super(errorLevel);
	}
	
	
	// --- Inner Classes ---
	
    /**
     * A class to allow the pass-through of progress.
     * 
     * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
     * @since 3rd Nov 2006
     */
    public final static class Progress<T, V> {
        private final BusinessTask<T, V> task;
        
        public Progress(BusinessTask<T, V> task) {
            this.task = task;
        }
        
        /**
         * Pass-through method to the tasks {@code #setProgress(int,int,int)}
         * method (kinda breaking the encapsulation!).
         * 
         * @param value
         * @param min
         * @param max
         */
        public final void setProgress(int value, int min, int max) {
            this.task.setProgress(value, min, max);
        }
        
        /**
         * Passthrough method to the tasks {@code #setProgress(float)} method
         * (kinda breaking the encapsulation!).
         * 
         * @param percentage
         */
        public final void setProgress(float percentage) {
            this.task.setProgress(percentage);
        }
        
        /**
         * Passthrough method to the tasks
         * {@code #setProgress(float,float,float)} method (kinda breaking the
         * encapsulation!). 
         * 
         * @param value
         * @param min
         * @param max
         */
        public final void setProgress(float value, float min, float max) {
            this.task.setProgress(value, min, max);
        }
    }
}
