package civvi.osgi.desktop.swingx;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.awt.Window;

import javax.swing.Action;
import javax.swing.JPanel;

import org.jdesktop.application.Application;

/**
 * Defines the basis of a component for editing a business entity.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 May 2009]
 * @param <E>
 */
public abstract class EditorComponent<E> extends JPanel {
	private static final long serialVersionUID = -5605955779348843827L;

	protected final AppFrameworkSupport<Application<?>> support;

	private E editableBean;
	private boolean editable = true;

	/**
	 * 
	 * TODO
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since v1.0.0 [19 May 2009]
	 */
	public enum State {
		DEFAULT,
		CANCELLED,
		SAVED,
		ERRORED
	}

	private State state = State.DEFAULT;


	/**
	 * Default constructor.
	 */
	public EditorComponent() {
		this(new BorderLayout());
	}

	/**
	 * Constructs an editor component with the given layout manager.
	 * 
	 * @param layout
	 */
	public EditorComponent(LayoutManager layout) {
		super(layout);
		this.support = new AppFrameworkSupport<Application<?>>(this);
	}

	/**
	 * @return an array of actions that will appear in addition to the cancel
	 * and save actions.
	 */
	public Action[] getOtherActions() {
		return new Action[0];
	}

	/**
	 * @return the action that performs a save, or {@code null}.
	 */
	public Action getHelpAction() {
		return support.getAction("help");
	}

	/**
	 * @return the action that performs a save, or {@code null}.
	 */
	public Action getSaveAction() {
		return support.getAction("save");
	}

	/**
	 * @return the action that performs a cancel. This action, at some point is
	 * required to call {@link #disposeDialog()} to close and cleanup the
	 * parent dialog.
	 */
	public Action getCancelAction() {
		return support.getAction("cancel");
	}

	/**
	 * Sets the state of the editor to cancelled. Is used in conjunction with 
	 * {@link UIFactory#showEditorDialog(java.awt.Component, EditorComponent, String)}
	 * this will also hide and dispose of the dialog.
	 */
	@org.jdesktop.application.Action
	public void cancel() {
		setState(State.CANCELLED);
	}

	/**
	 * Hides then disposes of the parent dialog.
	 */
	public void disposeDialog() {
		final Window window = SwingUtil.getWindowForComponent(this);
		window.dispose();
	}

	/**
	 * @return the state.
	 */
	public State getState() {
		return state;
	}

	/**
	 * @param state the state to set.
	 */
	public void setState(State state) {
		final State oldValue = getState();
		this.state = state;
		firePropertyChange("state", oldValue, getState());
	}

	/**
	 * @return the editable.
	 */
	public E getEditableBean() {
		return editableBean;
	}

	/**
	 * @param editableBean the editable to set.
	 */
	public void setEditableBean(E editableBean) {
		final E oldValue = getEditableBean();
		this.editableBean = editableBean;
		firePropertyChange("editableBean", oldValue, getEditableBean());
	}

	/**
	 * @return the editable.
	 */
	public boolean isEditable() {
		return editable;
	}

	/**
	 * @param editableBean the editable to set.
	 */
	public void setEditable(boolean editable) {
		final boolean oldValue = isEditable();
		this.editable = editable;
		firePropertyChange("editable", oldValue, isEditable());
	}

	/**
	 * 
	 * @param editableBean
	 */
	protected abstract void updateFields(E editableBean);

	/**
	 * 
	 * @return
	 */
	protected E updateBean() {
		return getEditableBean();
	}
}
