package civvi.osgi.desktop.swingx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

import javax.swing.ListModel;

import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;

/**
 * Abstract implementation of a {@link ListModel} for use with BeansBinding
 * (JSR295).
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 22nd October 2007
 * @param <E> Element type
 */
public class GenericListModel<E>
extends javax.swing.AbstractListModel
implements List<E> {
	private static final long serialVersionUID = 7270603600840463973L;

	private final ObservableListHandler observableListHandler;

	private ObservableList<E> elements;

	/**
	 * Default constructor.
	 */
	public GenericListModel() {
		this.observableListHandler = new ObservableListHandler(this);
		set(new ArrayList<E>()); // set empty list
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public E getElementAt(int index) {
		return get(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int getSize() {
		return size();
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public E get(int index) {
		return this.elements.get(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean add(E e) {
		return this.elements.add(e);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void add(int index, E element) {
		this.elements.add(index, element);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean addAll(Collection<? extends E> c) {
		return this.elements.addAll(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean addAll(int index, Collection<? extends E> c) {
		return this.elements.addAll(index, c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void clear() {
		this.elements.clear();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean contains(Object o) {
		return this.elements.contains(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean containsAll(Collection<?> c) {
		return this.elements.containsAll(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int indexOf(Object o) {
		return this.elements.indexOf(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isEmpty() {
		return this.elements.isEmpty();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Iterator<E> iterator() {
		return this.elements.iterator();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int lastIndexOf(Object o) {
		return this.elements.lastIndexOf(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ListIterator<E> listIterator() {
		return this.elements.listIterator();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public ListIterator<E> listIterator(int index) {
		return this.elements.listIterator(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean remove(Object o) {
		return this.elements.remove(o);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public E remove(int index) {
		return this.elements.remove(index);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean removeAll(Collection<?> c) {
		return this.elements.removeAll(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean retainAll(Collection<?> c) {
		return this.elements.retainAll(c);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public E set(int index, E element) {
		return this.elements.set(index, element);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int size() {
		return this.elements.size();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public List<E> subList(int fromIndex, int toIndex) {
		return this.elements.subList(fromIndex, toIndex);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object[] toArray() {
		return this.elements.toArray();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public <T> T[] toArray(T[] a) {
		return this.elements.toArray(a);
	}
	
	/**
	 * @param elements the elements to set.
	 */
	public void set(List<E> elements) {
		final ObservableList<E> oldValue = this.elements;

		if (oldValue != null)
			oldValue.removeObservableListListener(this.observableListHandler);

		if (elements instanceof ObservableList<?>) {
			this.elements = (ObservableList<E>) elements;
		} else {
			this.elements = ObservableCollections.observableList(elements);
		}

		this.elements.addObservableListListener(this.observableListHandler);
		fireContentsChanged(this, 0, getSize());
	}

	
	// --- Inner Classes ---

	/**
	 * A listener for passing events to the model.
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 22nd October 2007
	 */
	@SuppressWarnings("rawtypes") 
	private static class ObservableListHandler
	implements ObservableListListener
	{
		private final GenericListModel<?> model;

		private ObservableListHandler(GenericListModel<?> model) {
			this.model = model;
		}

		@Override
		public void listElementsAdded(
				ObservableList list,
				int index,
				int length)
		{
			this.model.fireIntervalAdded(this, index, index + length);
		}

		@Override
		public void listElementsRemoved(
				ObservableList list,
				int index,
				List oldElements)
		{
			this.model.fireIntervalRemoved(
					this, index, index + oldElements.size());
		}

		@Override
		public void listElementReplaced(
				ObservableList list,
				int index,
				Object oldElement)
		{
			this.model.fireContentsChanged(this, index, index);
		}

		@Override
		public void listElementPropertyChanged(
				ObservableList list,
				int index)
		{
			this.model.fireContentsChanged(this, index, index);
		}
	}
}
