package civvi.osgi.desktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

import org.jdesktop.swingx.JXPanel;

/**
 * A decorator to add a information facility to the {@link JComponent}.
 * Once attached the when the mouse it rolled over the component a button will
 * be displayed. This button will be in the upper-right most corner of the 
 * component. The button will take the details of the given {@link Action} as
 * it's configuration.
 * <p/>
 * NOTE Dangle: I've set the {@link JComponent} and {@link Action} as weak
 * references to allow the decorator to clean up after. This isn't well
 * tested so the references may remain.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 3rd Nov 2006
 */
public class InformationDecorator {
	private static final int PREFERRED_INSET = 5;
	
	/**
	 * Private constructor.
	 */
	private InformationDecorator() {
		// prevent initialisation
	}
	
	/**
	 * Attaches a information button to the component. This button will be
	 * attached to the upper-right most corner of the component. This will
	 * only appear when the user rolls the mouse over the component it is
	 * attached to.
	 *
	 * @param component the component to attach to.
	 * @param action the action that will be fired if the user clicks on the
	 * information button.
	 */
	public static void decorate(JTextComponent component, Action action) {
		component.addMouseListener(new RolloverMouseHandler(component, action));
	}
	
	/**
	 * Attaches a information button to the component. This button will be
	 * attached to the upper-right most corner of the component. This will
	 * only appear when the user rolls the mouse over the component it is
	 * attached to.
	 *
	 * @param component the component to attach to.
	 * @param action the action that will be fired if the user clicks on the
	 * information button.
	 */
	public static void decorate(JComboBox component, Action action) {
		if (true) {
			throw new UnsupportedOperationException();
		}
		
		// FIXME Dangle: combos have buttons to the right... got to leapfrog it.
/*		if (component.getRootPane().getGlassPane() == null) {
			component.getRootPane().setGlassPane(new GlassPane());
		} else if (!(component.getRootPane().getGlassPane() instanceof GlassPane)) {
			throw new IllegalArgumentException(
					"The glass pane of the RootPane must be of type: "
					+ GlassPane.class.getName());
		}
		component.addMouseListener(new RolloverMouseHandler(component, action));
*/
	}

	
	// --- Inner Classes ---
	
	/**
	 * TODO Dangle: type
	 *
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 3 Nov 2006
	 */
	private static class RolloverMouseHandler extends MouseAdapter {
		private JXPanel panel;
		private WeakReference<JComponent> componentReference;
		private WeakReference<Action> actionReference;
		
		/**
		 * TODO Dangle: constructor
		 *
		 * @param component
		 * @param action
		 */
		public RolloverMouseHandler(JComponent component, Action action) {
			super();
			
			this.componentReference = new WeakReference<JComponent>(component);
			this.actionReference = new WeakReference<Action>(action);
		}
		
		/**
		 * {@inheritDoc}
		 */
		@Override
		public void mouseEntered(MouseEvent me) {
			if (this.panel == null) {
				this.panel = new JXPanel(new BorderLayout());
				this.panel.setAlpha(0.75f);
				JButton button = new JButton(this.actionReference.get());
				button.setText(null);
				button.setMargin(null);
				button.setOpaque(false);
				button.setBorder(null);
				button.addFocusListener(new FocusAdapter() {
					@Override
					public void focusLost(FocusEvent fe) {
						panel.setVisible(false);
					}
				});
				this.panel.add(button, BorderLayout.CENTER);
	    	}
	    	
			JComponent component = this.componentReference.get();
			
	    	Container glassPane = getGlassPane(component);
	        // Only allow one message box to be visible at a time so
	        // pop down any visible message boxes
	        Component glassPaneChildren[] = glassPane.getComponents();
	        for(int i = 0; i < glassPaneChildren.length; i++) {
	            glassPaneChildren[i].setVisible(false);
	            glassPane.remove(glassPaneChildren[i]);
	        }
	        
//	        Icon icon = button.getIcon();
	        Dimension dimension = this.panel.getPreferredSize();
	        int inset = PREFERRED_INSET;
	        
	        // if smaller than inset, attempt to center vertically
	        if (component.getHeight() < dimension.height + (2 * inset)) {
	        	inset = component.getHeight() / 2 - dimension.height / 2;
	        }
	        
	        // convert component position to RootPane position
	        Point point = SwingUtilities.convertPoint(component, 0, 0, component.getRootPane());
	        
	        glassPane.setLayout(null);
	        this.panel.setBounds(
	        		(int) point.getX() + component.getWidth() - inset - dimension.width,
	        		(int) point.getY() + inset,
	        		dimension.width,
	        		dimension.height);
	        glassPane.add(this.panel);
	        this.panel.setVisible(true);
	        glassPane.setVisible(true);
	        glassPane.repaint();
		}
		
		/**
		 * TODO Dangle: method
		 *
		 * @param component
		 * @return
		 * @throws IllegalArgumentException
		 */
		private Container getGlassPane(JComponent component) {
			if (!(component.getRootPane().getGlassPane() instanceof GlassPane)) {
				component.getRootPane().setGlassPane(new GlassPane());
			}
			return (Container) component.getRootPane().getGlassPane();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void mouseExited(MouseEvent e) {
			if (!this.panel.contains(SwingUtilities.convertPoint(
					e.getComponent(), e.getPoint(), this.panel)))
			{
				this.panel.setVisible(false);		
			}
		}
	}
	
	/**
	 * TODO Dangle: type
	 *
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 3 Nov 2006
	 */
	private static class GlassPane extends JXPanel {
		private static final long serialVersionUID = 1L;
		
		/**
		 * TODO Dangle: constructor
		 */
		public GlassPane() {
			setOpaque(false);
		}

		/**
		 * Overriden so the glasspane is transparent and does not receive
		 * events. However, the child components do.
		 * {@inheritDoc}
		 */
		@Override
		public boolean contains(int x, int y) {
			Component[] components = getComponents();
			for (Component component : components) {
				if (component.contains(SwingUtilities.convertPoint(
						this, x, y, component)))
				{
					return true;
				}
			}
			return false;
		}
	}
}
