package civvi.osgi.desktop.swingx;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

import civvi.osgi.desktop.swingx.lighttable.Slide;
import civvi.osgi.desktop.swingx.plaf.JXLightTablePaneAddon;
import civvi.osgi.desktop.swingx.plaf.LightTablePaneUI;

/**
 * 
 * TODO Type comment.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 11 Dec 2007
 */
public class JXLightTablePane extends JXPanel {
	private static final long serialVersionUID = 1229951226390146088L;
	public final static String uiClassID = "LightTablePaneUI";

	static {
		LookAndFeelAddons.contribute(new JXLightTablePaneAddon());
	}

	private final List<Image> images;
	
	
	public JXLightTablePane() {
		this.images = new ArrayList<Image>();
	}
	
	
	/**
	 * Returns the name of the L&F class that renders this component.
	 * 
	 * @return the string {@link #uiClassID}
	 * @see javax.swing.JComponent#getUIClassID
	 * @see javax.swing.UIDefaults#getUI
	 */
	@Override
	public String getUIClassID() {
		return uiClassID;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public LightTablePaneUI getUI() {
		return (LightTablePaneUI) super.getUI();
	}
	
	
	public void setImages(Image... images) {
		// TODO Auto-generated method stub

	}
	
	public void add(BufferedImage image) {
		this.images.add(image);
		final Slide slide = new Slide(image);
		getUI().decorate(slide);
		add(slide);
	}
	
	
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				JFrame frame = new JFrame("My Frame");
				frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
				JXLightTablePane lightTablePane = new JXLightTablePane();
				frame.setContentPane(lightTablePane);
				
				try {
					final BufferedImage image = ImageIO.read(new File("./image.jpg"));
				
					for (int i = 0; i < 20; i++) {
						lightTablePane.add(image);
					}
				} catch (IOException ioe) {
					ioe.printStackTrace();
				}
				frame.setSize(640, 480);
				frame.setVisible(true);
			}
		});
	}
}
