package civvi.osgi.desktop.swingx;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.TabbedPaneUI;

/**
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since v1.0.0 [23 May 2010]
 */
public class JXTabbedPane extends JTabbedPane {
	private static final long serialVersionUID = 8882959993150466007L;

	public JXTabbedPane() {

		ToolTipManager.sharedInstance().registerComponent(this);

		addMouseListener(new MouseAdapter() {
			public void mouseClicked(MouseEvent e) {
				if (connectedIconBounds != null
						&& (e.getModifiers() & MouseEvent.BUTTON1_MASK) != 0
						&& connectedIconBounds.contains(e.getPoint())) {

					if (isConnected()) {
						disconnect();
					} else {
						connect();
					}
					repaint();
				}
			}
		});

	}

	private Icon connectedIcon16 =
		new ImageIcon(getClass().getResource("resources/connected16.png"));
	private Icon connectedIcon24 =
		new ImageIcon(getClass().getResource("resources/connected24.png"));
	private Icon disconnectedIcon16 =
		new ImageIcon(getClass().getResource("resources/disconnected16.png"));
	private Icon disconnectedIcon24 =
		new ImageIcon(getClass().getResource("resources/disconnected24.png"));

	private Rectangle connectedIconBounds;

	// Override to increase right inset for tab area,
	// in order to reserve space for the connect toggle.
	public void setUI(TabbedPaneUI ui) {
		Insets insets = (Insets)UIManager.getLookAndFeelDefaults().get("TabbedPane.tabAreaInsets");
		insets = (Insets)insets.clone();
		insets.right += connectedIcon24.getIconWidth() + 8;
		UIManager.put("TabbedPane.tabAreaInsets", insets);
		super.setUI(ui);
	}

	// Override to paint the connect toggle
	protected void paintComponent(Graphics g) {
		super.paintComponent(g);

		Icon icon;
		Component c0 = getComponent(0);
		if (c0 != null && c0.getY() > 24) {
			icon = isConnected() ? connectedIcon24 : disconnectedIcon24;
		} else {
			icon = isConnected() ? connectedIcon16 : disconnectedIcon16;
		}
		Insets insets = getInsets();
		int x = getWidth() - insets.right - icon.getIconWidth() - 4;
		int y = insets.top;
		if (c0 != null) {
			y = (c0.getY() - icon.getIconHeight()) / 2;
		}
		icon.paintIcon(this, g, x, y);
		connectedIconBounds = new Rectangle(x, y, icon.getIconWidth(), icon.getIconHeight());
	}

	private boolean isConnected() {
		return false;
	}


	public synchronized void removeTabAt(int index) {
		super.removeTabAt(index);
	}

	public void connect() {

	}

	public void disconnect() {
	}

	// Convenience methods
	protected static String getText(String key, Object... args) {
		return key; //Resources.getText(key, args);
	}
}
