package civvi.osgi.desktop.swingx;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

import civvi.osgi.desktop.swingx.plaf.basic.EclipseTabbedPaneUI;


/**
 * Eclipse style tabbedpane with elipse-look tabs and popup menu on tabs.
 * 
 * FIXME: save dirty tabs first
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @date 9-feb-2006
 */
public class JXTabbedPaneNew extends JTabbedPane {

	private static final long serialVersionUID = 1176020466013529902L;
	private JPopupMenu popupMenu;
	private Integer selectedTabIndex;

	public JXTabbedPaneNew() {
		super();
		setUI(new EclipseTabbedPaneUI());

		createPopupMenu();

		addMouseListener(new MouseAdapter() {

			@Override
			public void mouseReleased(MouseEvent mouseEvent) {
				JXTabbedPaneNew.this.mouseReleased(mouseEvent);
			}

		});
	}

	private void mouseReleased(MouseEvent mouseEvent) {

		if (mouseEvent.isPopupTrigger()) {
			selectedTabIndex = indexAtLocation(mouseEvent.getX(), mouseEvent.getY());

			// Only show for top row
			if (getTabPlacement() == JTabbedPane.TOP) {
				popupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
			}
		}

	}

	private JPopupMenu createPopupMenu() {

		popupMenu = new JPopupMenu();

		popupMenu.add(new CloseAction("Close"));
		popupMenu.add(new CloseOthersAction("Close Others"));
		popupMenu.add(new CloseAllAction("Close All"));

		return popupMenu;
	}

	private class CloseAction extends AbstractAction {

		private static final long serialVersionUID = -2625928077474199856L;

		public CloseAction(String name) {
			super(name);
		}

		public void actionPerformed(ActionEvent actionEvent) {
//			closeTab(selectedTabIndex);
		}
	}

	private class CloseOthersAction extends AbstractAction {

		private static final long serialVersionUID = -2625928077474199856L;

		public CloseOthersAction(String name) {
			super(name);
		}

		public void actionPerformed(ActionEvent actionEvent) {

			// First remove higher indexes 
			int tabCount = getTabCount();

			if (selectedTabIndex < tabCount - 1) {
				for (int i = selectedTabIndex + 1; i < tabCount; i++) {
//					closeTab(selectedTabIndex + 1);
				}
			}

			if (selectedTabIndex > 0) {
				for (int i = 0; i < selectedTabIndex; i++) {
	//				closeTab(0);
				}
			}
		}
	}

	private class CloseAllAction extends AbstractAction {

		private static final long serialVersionUID = -2625928077474199856L;

		public CloseAllAction(String name) {
			super(name);
		}

		public void actionPerformed(ActionEvent actionEvent) {

			int tabCount = getTabCount();

			for (int i = 0; i < tabCount; i++) {
//				closeTab(0);
			}
		}
	}
}