package civvi.osgi.desktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.UIManager;

import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;

import civvi.osgi.desktop.swingx.plaf.JXWizardAddon;
import civvi.osgi.desktop.swingx.plaf.WizardUI;
import civvi.osgi.desktop.swingx.wizard.StepController;
import civvi.osgi.desktop.swingx.wizard.StepPanel;
import civvi.osgi.desktop.swingx.wizard.WizardModel;
import civvi.osgi.desktop.swingx.wizard.WizardModelEvent;
import civvi.osgi.desktop.swingx.wizard.WizardModelListener;

/**
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since v1.0.0 [23 May 2010]
 */
public class JXWizard extends JXPanel implements WizardModelListener {
	private static final long serialVersionUID = 6636556448489738090L;
	public static final String uiClassID = "WizardUI";
	
	static {
		LookAndFeelAddons.contribute(new JXWizardAddon());
	}
	
	@SuppressWarnings("rawtypes")
	private StepController controller;
	private StepPanel panel;
	@SuppressWarnings("rawtypes")
	private WizardModel model;
	
	private JDialog dialog;
	
	private Action prevAction;
	private Action nextAction;
	private Action finishAction;
	private Action cancelAction;
	

	/**
	 * 
	 * TODO
	 * 
	 * @param resolver
	 */
	public JXWizard(StepController<?> resolver) {
		super(new BorderLayout());
		setResolver(resolver);
	}

	/**
	 * @return the prevAction.
	 */
	@SuppressWarnings("serial")
	public Action getPrevAction() {
		if (this.prevAction == null) {
			this.prevAction = new AbstractAction("< Previous") {
				@Override
				public void actionPerformed(ActionEvent e) {
					previous();
				}
			};
		}
		
		return prevAction;
	}

	/**
	 * @return the nextAction.
	 */
	@SuppressWarnings("serial")
	public Action getNextAction() {
		if (this.nextAction == null) {
			this.nextAction = new AbstractAction("Next >") {
				@Override
				public void actionPerformed(ActionEvent e) {
					next();
				}
			};
		}
		return nextAction;
	}

	/**
	 * @return the finishAction.
	 */
	@SuppressWarnings("serial")
	public Action getFinishAction() {
		if (this.finishAction == null) {
			this.finishAction = new AbstractAction("Finish") {
				@Override
				public void actionPerformed(ActionEvent e) {
					finish();
				}
			};
		}
		return finishAction;
	}

	/**
	 * @return the cancelAction.
	 */
	@SuppressWarnings("serial")
	public Action getCancelAction() {
		if (this.cancelAction == null) {
			this.cancelAction = new AbstractAction("Cancel") {
				@Override
				public void actionPerformed(ActionEvent e) {
					cancel();
				}
			};
		}
		return cancelAction;
	}

	/**
	 * @return the model.
	 */
	@SuppressWarnings("rawtypes")
	public WizardModel getModel() {
		return model;
	}

	/**
	 * @param model the model to set.
	 */
	public void setModel(WizardModel<?> model) {
		final WizardModel<?> oldValue = getModel();
		if (oldValue != null) {
			oldValue.removeListener(this);
		}
		this.model = model;

		if (this.model != null) {
			this.model.addListener(this);
		}
		firePropertyChange("model", oldValue, getModel());
	}

	/**
	 * @return the resolver.
	 */
	@SuppressWarnings("rawtypes")
	public StepController getController() {
		return this.controller;
	}

	/**
	 * @param resolver the resolver to set.
	 */
	public void setResolver(StepController<?> resolver) {
		final StepController<?> oldValue = getController();
		this.controller = resolver;
		firePropertyChange("controller", oldValue, getController());
	}

	/**
	 * @return the panel.
	 */
	public StepPanel getPanel() {
		return this.panel;
	}

	/**
	 * 
	 * TODO
	 *
	 * @param panel
	 */
	protected void setPanel(StepPanel panel) {
		final StepPanel oldValue = getPanel();
		
		if (oldValue != null) {
//			oldValue.associate(getModel());
		}

		this.panel = panel;

		if (this.panel != null) {
			this.panel.associate(getModel());
		}
		firePropertyChange("stepPanel", oldValue, getPanel());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	@SuppressWarnings("unchecked")
	public void wizardChanged(WizardModelEvent e) {
		if ("step".equals(e.getName())) {
			setPanel(getController().getPanel(e.getNewValue(), this.model));
		}
		this.getPrevAction().setEnabled(
				getController().indexOfStep(e.getNewValue(), model) != 0);
		this.getNextAction().setEnabled(
				getPanel().validates() &&
				!getController().isFinishable(e.getNewValue(), this.model));
		this.getFinishAction().setEnabled(
				getPanel().validates() &&
				getController().isFinishable(e.getNewValue(), this.model));
	}

	/**
	 * Returns the name of the L&F class that renders this component.
	 * 
	 * @return the string {@link #uiClassID}
	 * @see javax.swing.JComponent#getUIClassID
	 * @see javax.swing.UIDefaults#getUI
	 */
	@Override
	public String getUIClassID() {
		return uiClassID;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public WizardUI getUI() {
		return (WizardUI) super.getUI();
	}
	
	/**
	 * 
	 * TODO
	 *
	 * @param parentComponent
	 * @param title
	 * @param style
	 * @return
	 * @throws HeadlessException
	 */
	public JDialog createDialog(
			Component parentComponent,
			String title,
			int style)
	throws HeadlessException
	{
		if (this.dialog != null) {
			throw new IllegalStateException("Dialog must be null!");
		}

		Window window = getWindowForComponent(parentComponent);
		if (window instanceof Frame) {
			this.dialog = new JDialog((Frame)window, title, true);	
		} else {
			this.dialog = new JDialog((Dialog)window, title, true);
		}

		initDialog(this.dialog, parentComponent);
		return this.dialog;
	}

	/**
	 * 
	 * TODO
	 *
	 * @param dialog
	 * @param parentComponent
	 */
	private void initDialog(final JDialog dialog, Component parentComponent) {
		dialog.setComponentOrientation(this.getComponentOrientation());
		Container contentPane = dialog.getContentPane();

		contentPane.setLayout(new BorderLayout());
		contentPane.add(this, BorderLayout.CENTER);
		dialog.setResizable(false);
		if (JDialog.isDefaultLookAndFeelDecorated()) {
			boolean supportsWindowDecorations =
				UIManager.getLookAndFeel().getSupportsWindowDecorations();
			if (supportsWindowDecorations) {
				dialog.setUndecorated(true);
//				getRootPane().setWindowDecorationStyle(style);
			}
		}
		dialog.setResizable(true);
		WindowAdapter adapter = new WindowAdapter() {
			private boolean gotFocus = false;
			public void windowClosing(WindowEvent we) {
				//				setValue(null);
			}
			public void windowGainedFocus(WindowEvent we) {
				// Once window gets focus, set initial focus
				if (!gotFocus) {
					//					selectInitialValue();
					gotFocus = true;
				}
			}
		};
		dialog.addWindowListener(adapter);
		dialog.addWindowFocusListener(adapter);
		dialog.addComponentListener(new ComponentAdapter() {
			public void componentShown(ComponentEvent ce) {
				// reset value to ensure closing works properly
				//				setValue(JOptionPane.UNINITIALIZED_VALUE);
			}
		});
		addPropertyChangeListener(new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent event) {
				// Let the defaultCloseOperation handle the closing
				// if the user closed the window without selecting a button
				// (newValue = null in that case).  Otherwise, close the dialog.
				if (dialog.isVisible() && event.getSource() == JXWizard.this &&
						/*						(event.getPropertyName().equals(VALUE_PROPERTY)) &&*/
						event.getNewValue() != null //&&
				/*						event.getNewValue() != JOptionPane.UNINITIALIZED_VALUE*/) {
//					dialog.setVisible(false);
				}
			}
		});
	}

	/**
	 * 
	 * TODO
	 *
	 */
	@SuppressWarnings("unchecked")
	public void start() {
		getModel().setStep(getController().getStepId(0, getModel()));
	}

	/**
	 * 
	 * TODO
	 *
	 */
	@SuppressWarnings("unchecked")
	public void next() {
		final int index = getController().indexOfStep(
				getModel().getStep(),
				getModel());

		getModel().setStep(getController().getStepId(index + 1, getModel()));
	}

	/**
	 * 
	 * TODO
	 *
	 */
	@SuppressWarnings("unchecked")
	public void previous() {
		final int index = getController().indexOfStep(
				getModel().getStep(),
				getModel());

		getModel().setStep(getController().getStepId(index - 1, getModel()));
	}

	/**
	 * 
	 * TODO
	 *
	 */
	@SuppressWarnings("unchecked")
	public void finish() {
		getController().finish(getModel());
		
		if (this.dialog != null) {
			this.dialog.setVisible(false);
			this.dialog.dispose();
			this.dialog = null;
		}
	}

	/**
	 * 
	 * TODO
	 *
	 */
	@SuppressWarnings("unchecked")
	public void cancel() {
		getController().cancel(getModel());
		
		if (this.dialog != null) {
			this.dialog.setVisible(false);
			this.dialog.dispose();
			this.dialog = null;
		}
	}


	// --- Static Methods ---

	/**
	 * Returns the specified component's top-level {@link Frame} or
	 * {@link Dialog}.
	 * 
	 * @param parentComponent the {@link Component} to check for a
	 * {@link Frame} or {@link Dialog}.
	 * @return the {@link Window} that contains the component, or the default
	 * frame if the component is {@code null}, or does not have a valid 
	 * {@link Frame} or {@link Dialog} parent
	 * @exception HeadlessException if {@link GraphicsEnvironment#isHeadless()}
	 * returns {@code true}.
	 * @see GraphicsEnvironment#isHeadless
	 */
	private static Window getWindowForComponent(Component parentComponent) 
	throws HeadlessException {
		if (parentComponent == null) {
			throw new NullPointerException("Parent component cannot be null!");
		}
		if (parentComponent instanceof Frame || parentComponent instanceof Dialog)
			return (Window) parentComponent;
		return getWindowForComponent(parentComponent.getParent());
	}

	/**
	 * 
	 * TODO
	 *
	 * @param <T>
	 * @param parentComponent
	 * @param modelType
	 * @param resolver
	 * @param title the dialog title.
	 * @return the model or {@code null} if the wizard was cancelled.
	 */
	public static <S, T extends WizardModel<S>> T show(
			Component parentComponent,
			Class<T> modelType,
			StepController<T> resolver,
			String title)
	{
		try {
			return modelType.cast(show(
					parentComponent,
					modelType.newInstance(),
					resolver,
					title));
		} catch (InstantiationException ie) {
			throw new IllegalArgumentException(
					"Model must have a no args constructor. Use #show(T model).",
					ie);
		} catch (IllegalAccessException iae) {
			throw new IllegalArgumentException(
					"Model must have a no args constructor. Use #show(T model).",
					iae);
		}
	}

	/**
	 * 
	 * TODO
	 *
	 * @param <T>
	 * @param parentComponent
	 * @param model
	 * @param resolver
	 * @param title the dialog title.
	 * @return the model or {@code null} if the wizard was cancelled.
	 */
	public static<M extends WizardModel<?>> M show(
			Component parentComponent,
			M model,
			StepController<M> resolver,
			String title)
	{
		final JXWizard wizard = new JXWizard(resolver);
		wizard.setModel(model);
		final JDialog dialog = wizard.createDialog(parentComponent, title, -1);
		wizard.start();
//		model.setStep(model.getStartStep());
		dialog.pack();
		dialog.setLocationRelativeTo(parentComponent);
		dialog.setVisible(true);
		dialog.dispose();
		model.removeListener(wizard);
		return model;
	}
}
