package civvi.osgi.desktop.swingx;

import java.util.logging.Level;

import javax.swing.SwingUtilities;

import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;

import civvi.common.LoggingExceptionHandler;
import civvi.osgi.desktop.OSGiDesktop;

/**
 * Handles uncaught exceptions by displaying a error dialog.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 26th October 2007
 */
public class SwingExceptionHandler extends LoggingExceptionHandler {
	static {
		// auto register as AWT handler
		System.setProperty(
				"sun.awt.exception.handler",
				SwingExceptionHandler.class.getName());
	}

    /**
     * @param t the exception thrown.
     */
    public void handle(Throwable t) {
        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(
                Thread.currentThread(), t);
    }

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void uncaughtException(Thread t, Throwable e) {
		super.uncaughtException(t, e);

		final ErrorInfo errorInfo = new ErrorInfo(
				"Uncaught Exception",
				"Uncaught Exception: " + e.getMessage(),
				"Uncaught Exception: " + e.getMessage(),
				"UNCAUGHT",
				e,
				Level.SEVERE,
				null);

		SwingUtilities.invokeLater(new ErrorRunnable(errorInfo));
	}


	// --- Inner Classes ---
	
	/**
	 * <p>
	 * TODO
	 * </p>
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 26th October 2007
	 */
	private static class ErrorRunnable implements Runnable {
		private final ErrorInfo errorInfo;

		public ErrorRunnable(ErrorInfo errorInfo) {
			this.errorInfo = errorInfo;
		}

		@Override
		public void run() {
			OSGiDesktop desktop = (OSGiDesktop) OSGiDesktop.getContext().getApplication();
			desktop.getErrorList().add(this.errorInfo);
			// this could cause error popup hell, so maybe group?!
			if (desktop.getMainTopLevel() == null)
				JXErrorPane.showFrame(null, errorInfo);
			else 
				JXErrorPane.showDialog(
						desktop.getMainTopLevel(),
						errorInfo);
		}	
	}
}
