package civvi.osgi.desktop.swingx;

import java.awt.BorderLayout;

import javax.swing.Icon;
import javax.swing.JSeparator;

import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXPanel;

/**
 * A class to create common components for the desktop.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [9 Jun 2010]
 */
public class SwingFactory {
	private SwingFactory() {
		// prevent init!
	}

	/**
	 * 
	 * TODO
	 * @param title
	 * @param description
	 * @param icon
	 * @return
	 */
	public static JXHeader createHeader(String title, String description, Icon icon) {
		return new JXHeader(title, description, icon);
	}

	/**
	 * 
	 * TODO
	 * @param title
	 * @param description
	 * @param icon
	 * @return
	 */
	public static JXPanel createHeaderPane(String title, String description, Icon icon) {
		return createHeaderPane(createHeader(title, description, icon));
	}

	/**
	 * 
	 * TODO
	 * @param header
	 * @return
	 */
	public static JXPanel createHeaderPane(JXHeader header) {
		final JXPanel pane = new JXPanel(new BorderLayout());
		pane.add(header, BorderLayout.CENTER);
		pane.add(new JSeparator(), BorderLayout.SOUTH);
		return pane;
	}
}
