package civvi.osgi.desktop.swingx.docking;

/**
 * A factory for creating {@link AbstractDockable}s.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 22th November 2007
 */
public interface DockableFactory {
	/**
	 * Creates a new dockable for the given key.
	 * 
	 * @param key the key of the dockable.
	 * @return the new instance, or {@code null} key is unknown. 
	 */
	AbstractDockable create(Object key);

	/**
	 * 
	 * TODO
	 *
	 * @param key
	 * @return
	 */
	Class<? extends AbstractDockable> getClass(Object key);
}
