package civvi.osgi.desktop.swingx.docking.perspective;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Perspective complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="Perspective">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Layout" type="{http://www.w3.org/2001/XMLSchema}string"/>
 *         &lt;element name="PerspectiveLeaf" type="{http://www.civvi.com/rmc/Perspectives}PerspectiveLeaf" maxOccurs="unbounded"/>
 *       &lt;/sequence>
 *       &lt;attribute name="name" type="{http://www.w3.org/2001/XMLSchema}string" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a> 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Perspective", propOrder = {
    "layout",
    "leafs"
})
public class Perspective {
    @XmlElement(name = "layout", required = true)
    protected String layout;
    @XmlElement(name = "leaf", required = true)
    protected List<PerspectiveLeaf> leafs;
    @XmlAttribute
    protected String id;

    /**
     * 
     * TODO
     * @param id
     */
    public Perspective(String id) {
		this();
		setId(id);
	}
    
    /**
     * Default Constructor.
     */
    public Perspective() {
		super();
	}

    public String getLayout() {
        return layout;
    }

    public void setLayout(String value) {
        this.layout = value;
    }

    public List<PerspectiveLeaf> getLeafs() {
        if (leafs == null) {
            leafs = new ArrayList<PerspectiveLeaf>();
        }
        return this.leafs;
    }

    /**
     * 
     * TODO
     * @param id
     * @return
     */
    public PerspectiveLeaf getLeaf(String id) {
    	for (PerspectiveLeaf leaf : getLeafs()) {
    		if (leaf.getId().equals(id)) {
    			return leaf;
    		}
    	}
    	return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String value) {
        this.id = value;
    }

}
