package civvi.osgi.desktop.swingx.filter;

import java.awt.image.BufferedImageOp;

import com.jhlabs.image.FadeFilter;
import com.jhlabs.image.PointFilter;

/**
 * A {@link BufferedImageOp} to fade the image to transparent over th
 * course of its length.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 8 Dec 2006
 */
public class LinerFadeFilter extends PointFilter {
	static final long serialVersionUID = 1L;

	private int endOpacity;
	private int startOpacity;
	private int width;

	/**
	 * Construct an {@link FadeFilter} with the given opacity (alpha).
	 * 
	 * @param startOpacity the opacity (alpha) in the range 0..255
	 * @param endOpacity the opacity (alpha) in the range 0..255
	 */
	public LinerFadeFilter(int startOpacity, int endOpacity) {
		setEndOpacity(endOpacity);
		setStartOpacity(startOpacity);
	}

	/**
	 * @param startOpacity the opacity (alpha) in the range 0..255
	 */
	public void setEndOpacity(int startOpacity) {
		this.endOpacity = startOpacity;
	}

	/**
	 * @param endOpacity the opacity (alpha) in the range 0..255
	 */
	public void setStartOpacity(int endOpacity) {
		this.startOpacity = endOpacity;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int filterRGB(int x, int y, int rgb) {
		if ((rgb & 0xff000000) != 0) {
			int diff = this.endOpacity - this.startOpacity;
			// weight the difference by the width of the image
			int current = Math.round((float) diff * (float) x / this.width);
			return (rgb & 0xffffff) | (current + this.startOpacity << 24);
		}
		return rgb;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setDimensions(int width, int height) {
		this.width = width;
	}
}
