package civvi.osgi.desktop.swingx.lighttable;

import java.awt.BorderLayout;
import java.awt.Image;
import java.awt.image.BufferedImage;

import org.jdesktop.swingx.JXPanel;

/**
 * 
 * TODO Type comment.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 11 Dec 2007
 */
public class Slide extends JXPanel {
	private static final long serialVersionUID = -6724193874762886589L;
	
	private BufferedImage image;
	private double rotation;
	
	
	/**
	 * 
	 * TODO Constructor comment.
	 *
	 * @param image
	 */
	public Slide(BufferedImage image) {
		super(new BorderLayout());
		setImage(image);
	}
	
	/**
	 * 
	 * TODO Method comment.
	 *
	 * @return
	 */
	public BufferedImage getImage() {
		return this.image;
	}

	/**
	 * 
	 * TODO Method comment.
	 *
	 * @param image
	 */
	public void setImage(BufferedImage image) {
		final Image oldValue = getImage();
		this.image = image;
		firePropertyChange("image", oldValue, getImage());
	}

	/**
	 * @return the rotation.
	 */
	public double getRotation() {
		return rotation;
	}

	/**
	 * @param rotation the rotation to set.
	 */
	public void setRotation(double rotation) {
		double oldValue = getRotation();
		this.rotation = rotation;
		firePropertyChange("rotation", oldValue, getRotation());
	}

	/**
	 * @return the landscape.
	 */
	public boolean isLandscape() {
		final BufferedImage image = getImage();
		return image != null ? image.getWidth() < image.getHeight() : false;
	}
}
