package civvi.osgi.desktop.swingx.lighttable;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;

import javax.imageio.ImageIO;
import javax.swing.JComponent;

import org.jdesktop.swingx.painter.effects.AreaEffect;

import civvi.osgi.desktop.swingx.painter.AbstractGeomAreaPainter;

/**
 * TODO Type comment.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 12 Dec 2007
 */
public class SlideImagePainter extends AbstractGeomAreaPainter {
	private transient BufferedImage img;

	private AreaEffect[] areaEffects = new AreaEffect[0];

	private boolean scaleToFit = false;

	/**
	 * Create a new ImagePainter. By default there is no image, and the alignment
	 * is centered.
	 */
	public SlideImagePainter() {
		this((BufferedImage)null);
	}

	/**
	 * Create a new ImagePainter with the specified image and the Style
	 * Style.CENTERED
	 *
	 * @param image the image to be painted
	 */
	public SlideImagePainter(BufferedImage image) {
		super();
		setCacheable(true);
		this.img = image;
	}

	/**
	 * 
	 * TODO Constructor comment.
	 *
	 * @param url
	 * @throws IOException
	 */
	public SlideImagePainter(URL url) throws IOException {
		this(ImageIO.read(url));
	}

	/**
	 * Sets the image to paint with.
	 * @param image if null, clears the image. Otherwise, this will set the
	 * image to be painted.
	 */
	public void setImage(BufferedImage image) {
		if (image != img) {
			Image oldImage = img;
			img = image;
			setDirty(true);
			firePropertyChange("image", oldImage, img);
		}
	}

	/**
	 * Gets the current image used for painting.
	 * @return the image used for painting
	 */
	public BufferedImage getImage() {
		return img;
	}

	/**
	 * Sets the path effects to be drawn on this painter. Set this to null in order to remove all installed effects.
	 * @param pathEffects the effects to apply to this painter
	 */
	public void setAreaEffects(AreaEffect... areaEffects) {
		AreaEffect[] old = getAreaEffects();
		this.areaEffects = new AreaEffect[areaEffects == null ? 0 : areaEffects.length];
		if (areaEffects != null) {
			System.arraycopy(areaEffects, 0, this.areaEffects, 0, this.areaEffects.length);
		}
		setDirty(true);
		firePropertyChange("areaEffects", old, getAreaEffects());
	}

	/**
	 * Gets the current set of path effects applied to this painter. Returned array is guarantied to be not null.
	 * @return the effects applied to this path painter
	 */
	public AreaEffect[] getAreaEffects() {
		AreaEffect[] results = new AreaEffect[areaEffects.length];
		System.arraycopy(areaEffects, 0, results, 0, results.length);
		return results;
	}

	/**
	 * @inheritDoc
	 */
	public void doPaint(Graphics2D g, JComponent component, int width, int height) {
		paintBackground(g, component, width, height);
		paintImage(g, component, width, height);
	}
	
	/**
	 * 
	 * TODO Method comment.
	 *
	 * @param g
	 * @param component
	 * @param width
	 * @param height
	 */
	protected void paintBackground(Graphics2D g, JComponent component, int width, int height) {
		
	}
	
	/**
	 * 
	 * TODO Method comment.
	 *
	 * @param g
	 * @param component
	 * @param width
	 * @param height
	 */
	protected void paintImage(Graphics2D g, JComponent component, int width, int height) {
		final BufferedImage img = getImage();

		if (img != null) {
			int imgWidth = img.getWidth(null);
			int imgHeight = img.getHeight(null);
			if (imgWidth == -1 || imgHeight == -1) {
				//image hasn't completed loading, do nothing
			} else {
				Rectangle2D rect = calculateViewable();
				int sw = imgWidth;
				int sh = imgHeight;

				if (this.scaleToFit) {
					if(sw > width) {
						double scale = (double) width / (double) imgWidth * rect.getWidth();
						sw = (int)(sw * scale);
						sh = (int)(sh * scale);
					}
					if(sh > height) {
						double scale = (double) height / (double) imgHeight * rect.getHeight();
						sw = (int)(sw * scale);
						sh = (int)(sh * scale);
					}
				} else {
					sw = (int) ((double) width / (double) imgWidth * rect.getWidth() * imgWidth);
					sh = (int) ((double) height / (double) imgHeight * rect.getHeight() * imgHeight);
				}

				if(getAreaEffects() != null) { // FIXME erm?! Will this work?
					for(AreaEffect ef : getAreaEffects()) {
						ef.apply(img.createGraphics(), rect, width, height);
					}
				}
				
				g.drawImage(
						img,
						(int) (rect.getX() * width),
//						(int) (rect.getX() * width + width * rect.getWidth() / 2 - sw * rect.getWidth() / 2),
						(int) (rect.getY() * height),
//						(int) (rect.getY() * height + rect.getCenterY() - ),
						sw, sh, null);
			}
		}
	}

	public void setScaleToFit(boolean scaleToFit) {
		this.scaleToFit = scaleToFit;
		setDirty(true);
	}


	private double imageScale = 1.0;

	/**
	 * Sets the scaling factor used when drawing the image
	 * @param imageScale the new image scaling factor
	 */
	public void setImageScale(double imageScale) {
		double old = getImageScale();
		this.imageScale = imageScale;
		setDirty(true);
		firePropertyChange("imageScale",old,this.imageScale);
	}
	/**
	 * Gets the current scaling factor used when drawing an image.
	 * @return the current scaling factor
	 */
	public double getImageScale() {
		return imageScale;
	}
}
