package civvi.osgi.desktop.swingx.menu;

import java.util.EventObject;

import civvi.osgi.desktop.swingx.menu.MenuModel.Node;

/**
 * Defines an event in the {@link MenuModel}.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [13 Jun 2010]
 */
public class MenuModelEvent extends EventObject {
	private static final long serialVersionUID = 1L;

	/**
	 * Defines the type of event.
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since v1.0.0 [13 Jun 2010]
	 */
	public enum Type {
		/** Node added */
		ADDED,
		/** Node removed */
		REMOVED,
		/** Rebuild from model */
		REBUILD
	}

	private final Type type;
	private final Node node;
	private final String[] path;

	/**
	 * 
	 * TODO
	 * @param source
	 * @param path
	 */
	public MenuModelEvent(MenuModel source, Type type, Node node, String... path) {
		super(source);
		this.type = type;
		this.node = node;
		this.path = path;
	}

	/**
	 * @return the node that was added/removed.
	 */
	public String[] getPath() {
		return path;
	}

	/**
	 * 
	 * TODO
	 * @return
	 */
	public Node getNode() {
		return node;
	}
	
	/**
	 * @return the event type.
	 */
	public Type getType() {
		return type;
	}
}