package civvi.osgi.desktop.swingx.nullable;

import java.awt.Component;
import java.awt.event.ActionListener;

import javax.swing.ComboBoxEditor;

/**
 * A {@link ComboBoxEditor} that allows null.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 7 Jul 2006
 */
public class NullableComboBoxEditor implements ComboBoxEditor {
	private ComboBoxEditor delegate;

	/**
	 * Constructs a {@link ComboBoxEditor} that allows null values to be
	 * set.
	 *
	 * @param delegate the delegate editor.
	 */
	NullableComboBoxEditor(ComboBoxEditor delegate) {
		this.delegate = delegate;
	}

	/**
	 * <strong>NOTE</strong> If the returned item is empty String the return as
	 * {@code null}.
	 * 
	 * {@inheritDoc}
	 */
	@Override
	public Object getItem() {
		Object item = this.delegate.getItem();
		if (item instanceof String 
				&& "".equals(((String) item).trim()))
		{
			return null;
		}
		return item;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addActionListener(ActionListener l) {
		this.delegate.addActionListener(l);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Component getEditorComponent() {
		return this.delegate.getEditorComponent();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeActionListener(ActionListener l) {
		this.delegate.removeActionListener(l);			
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void selectAll() {
		this.delegate.selectAll();
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setItem(Object anObject) {
		this.delegate.setItem(anObject);
	}
}
