package civvi.osgi.desktop.swingx.nullable;

import javax.swing.JComboBox;

/**
 * A decorator to add the facility to select {@code null} within components.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 7 Jul 2006
 */
public class NullableDecorator {
	/**
	 * Private constructor.
	 */
	private NullableDecorator() {
		// prevent initialisation!
	}

	/**
	 * @param comboBox the {@link JComboBox} to decorate.
	 */
	public static void decorate(final JComboBox comboBox) {
		decorate(comboBox, null);
	}

	/**
	 * @param comboBox the {@link JComboBox} to decorate.
	 * @param nullText the text to display in the {@code null} position. If
	 * {@code null} then an empty string is used.
	 */
	public static void decorate(final JComboBox comboBox, final String nullText) {
		comboBox.setRenderer(new NullableListCellRenderer(comboBox.getRenderer(), nullText));
		// NOTE danielsi: editor required if using the autocomplete, due to a
		// really annoying bug with the DefaultComboBoxEditor
		comboBox.setEditor(new NullableComboBoxEditor(comboBox.getEditor()));
		comboBox.setModel(new NullableComboBoxModel(comboBox.getModel()));
	}

	/**
	 * @param comboBox the {@link JComboBox} to remove null decoration.
	 */
	public static void undecorate(final JComboBox comboBox) {
		throw new UnsupportedOperationException("TODO!");
	}
}
