package civvi.osgi.desktop.swingx.painter;

import java.awt.geom.Rectangle2D;

import javax.swing.JComponent;

import org.jdesktop.swingx.painter.AbstractPainter;

/**
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 12 Dec 2007
 * @param <T>
 */
public abstract class AbstractGeomAreaPainter
extends AbstractPainter<JComponent>
{
	private Insets2D insets;


	/**
	 * @return the insets.
	 */
	public Insets2D getInsets() {
		return this.insets;
	}

	/**
	 * @param insets the insets to set.
	 */
	public void setInsets(Insets2D insets) {
		Insets2D oldValue = getInsets();
		this.insets = insets;
		firePropertyChange("insets", oldValue, getInsets());
	}


	/**
	 * 
	 * TODO
	 *
	 * @return
	 */
	protected Rectangle2D calculateViewable() {
		final Insets2D insets = getInsets();
		if (insets != null)
			return new Rectangle2D.Double(
					insets.left,
					insets.top,
					1.0d - insets.left - insets.right,
					1.0d - insets.top - insets.bottom);

		return new Rectangle2D.Double(0.0d, 0.0d, 1.0d, 1.0d);
	}


	// --- Inner Classes ---

	/**
	 * 
	 * TODO
	 *
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 12 Dec 2007
	 */
	public static final class Insets2D {
		public final double top;
		public final double bottom;
		public final double left;
		public final double right;

		public Insets2D(double top, double bottom, double left, double right) {
			this.top = top;
			this.bottom = bottom;
			this.left = left;
			this.right = right;
		}
	}
}
