package civvi.osgi.desktop.swingx.painter;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;

import javax.swing.JComponent;

import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;

/**
 * A {@link Painter} for drawing a checkerboard pattern.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 8 Dec 2006
 */
public class CheckerboardPainter
extends AbstractPainter<JComponent>
{
	private Color c1;
	private Color c2;
	private int size;
	private Paint checkerPaint;


	/**
	 * Default constructor.
	 */
	public CheckerboardPainter() {
		this(Color.WHITE, new Color(240, 240, 240), 16);
	}

	/**
	 * Constructs a Checkerboard Painter with the following colours.
	 *
	 * @param c1
	 * @param c2
	 */
	public CheckerboardPainter(Color c1, Color c2, int size) {
		this.c1 = c1;
		this.c2 = c2;
		this.size = size;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doPaint(Graphics2D g, JComponent comp, int width, int height) {
		g.setPaint(getCheckerPaint());
		g.fillRect(0, 0, width, height);
	}

	/**
	 * A method to return a checkerboard image.
	 *
	 * @param c1 first colour.
	 * @param c2 second colour.
	 * @param size size of the squares.
	 * @return the Paint instance.
	 */
	private Paint getCheckerPaint() {
		if (this.checkerPaint == null) {
			BufferedImage img = new BufferedImage(size, size, BufferedImage.TYPE_INT_ARGB);
			Graphics g = img.getGraphics();
			g.setColor(this.c1);
			g.fillRect(0, 0, this.size, this.size);
			g.setColor(this.c2);
			g.fillRect(0, 0, this.size / 2, this.size / 2);
			g.fillRect(this.size / 2, this.size / 2, this.size / 2, this.size / 2);
			g.dispose();
			this.checkerPaint = new TexturePaint(img, new Rectangle(0, 0, this.size, this.size));
		}
		return this.checkerPaint;
	}
}
