package civvi.osgi.desktop.swingx.painter;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;

import javax.swing.JComponent;

import org.jdesktop.swingx.painter.AbstractPainter;

/**
 * Paints a grid on the component based on a percentage of the height of the
 * component. 
 *
 * @author <a href="mailto:dansiviter@gmail.com">Dan Siviter</a>
 * @since 8 Dec 2006
 */
public class GridPainter extends AbstractPainter<JComponent> {
	private Paint paint;

	private int height, width;
	private long vCells, hCells;

	private double cellSize, cellHeight;


	/**
	 * Constructs a new grid paint. Draws a grid for cells 25% of total height
	 * (4 cells).
	 *
	 * @param paint the paint to use for the grid.
	 */
	public GridPainter(Paint paint) {
		this(paint, 0.25d);
	}

	/**
	 * Constructs a new grid paint.
	 *
	 * @param paint the paint to use for the grid.
	 * @param cellSize the size of the cell proportion based on height of the
	 * component.
	 */
	public GridPainter(Paint paint, double cellHeight) {
		this.paint = paint;
		this.cellHeight = cellHeight;
	}

	/**
	 * Calculates the required values.
	 *
	 * @param height the height of the component.
	 * @param width the width of the component.
	 */
	private void calculateCellDimensions(int width, int height) {
		if (this.height == height && this.width == width) {
			return;
		}

		this.height = height;
		this.width = width;
		this.cellSize = this.height * this.cellHeight;
		this.hCells = Math.round(this.width / this.cellSize);
		this.vCells = Math.round(this.width / this.cellSize);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void doPaint(
			Graphics2D g,
			JComponent comp,
			int width,
			int height)
	{
		calculateCellDimensions(width, height);

		g.setPaint(this.paint);
		// columns
		for (int x = 1; x <= hCells; x++) {
			double currentX = comp.getWidth() - x * cellSize;
			g.draw(new Line2D.Double(currentX, 0, currentX, comp.getHeight()));
		}
		// rows
		for (int y = 1; y <= vCells; y++) {
			double currentY = y * cellSize - 1;
			g.draw(new Line2D.Double(0, currentY, comp.getWidth(), currentY));
		}
	}
}
