package civvi.osgi.desktop.swingx.plaf;

import javax.swing.plaf.PanelUI;

import civvi.osgi.desktop.swingx.JXDockingPane;
import civvi.osgi.desktop.swingx.docking.AbstractDock;
import civvi.osgi.desktop.swingx.docking.AbstractDockable;

/**
 * Abstract UI for {@link JXDockingPane}.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [20 Nov 2007]
 */
public abstract class DockingPaneUI extends PanelUI {
	/**
	 * Install UI to the {@link AbstractDock}. 
	 *
	 * @param dock
	 */
	public abstract void installUI(AbstractDock dock);

	/**
	 * Uninstall UI to the {@link AbstractDock}.
	 *
	 * @param dock
	 */
	public abstract void uninstallUI(AbstractDock dock);

	/**
	 * Install UI to the {@link AbstractDockable}.
	 *
	 * @param dockable
	 */
	public abstract void installUI(AbstractDockable dockable);

	/**
	 * Uninstall UI to the {@link AbstractDockable}.
	 *
	 * @param dockable
	 */
	public abstract void uninstallUI(AbstractDockable dockable);
}
