package civvi.osgi.desktop.swingx.plaf;

import javax.swing.LookAndFeel;

import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;

import civvi.osgi.desktop.swingx.JXDockingPane;
import civvi.osgi.desktop.swingx.plaf.basic.BasicDockingPaneUI;

/**
 * {@link JXDockingPane} component addons.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since 21st November 2007
 */
public class JXDockingPaneAddon extends AbstractComponentAddon {
	/**
	 * Creates a new instance of JXDockingPane
	 */
	public JXDockingPaneAddon() {
		super("JXDockingPane");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addBasicDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addBasicDefaults(addon, defaults);
		
		String clsName = JXDockingPane.class.getCanonicalName();
		
		defaults.add(
				JXDockingPane.uiClassID,
				BasicDockingPaneUI.class.getName());
//		defaults.add(clsName + ".closeAction.name", "Close");
		defaults.add(clsName + ".closeAction.icon", LookAndFeel.makeIcon(BasicDockingPaneUI.class, "resources/close.gif"));
		defaults.add(clsName + ".closeAction.rolloverIcon", LookAndFeel.makeIcon(BasicDockingPaneUI.class, "resources/closeRollover.gif"));

		UIManagerExt.addResourceBundle(
				"civvi.osgi.desktop.swingx.plaf.basic.resources.DockingPane");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addMetalDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addMetalDefaults(addon, defaults);

/*		if (isPlastic()) {
			defaults.addAll(Arrays.asList(new Object[] {
					"JXLoginPanel.banner.foreground",
					new ColorUIResource(Color.WHITE),
					"JXLoginPanel.banner.darkBackground",
					new ColorUIResource(Color.GRAY),
					"JXLoginPanel.banner.lightBackground",
					new ColorUIResource(Color.LIGHT_GRAY), }));
		} else {
			defaults.addAll(Arrays.asList(new Object[] {
					"JXLoginPanel.banner.foreground",
					new ColorUIResource(255, 255, 255),
					"JXLoginPanel.banner.darkBackground",
					MetalLookAndFeel.getCurrentTheme()
							.getPrimaryControlDarkShadow(),
					"JXLoginPanel.banner.lightBackground",
					MetalLookAndFeel.getCurrentTheme().getPrimaryControl() }));
		}*/
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addWindowsDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addWindowsDefaults(addon, defaults);
	/*	defaults.addAll(Arrays.asList(new Object[] {
				"JXLoginPanel.banner.foreground",
				new ColorUIResource(255, 255, 255),
				"JXLoginPanel.banner.darkBackground",
				new ColorUIResource(49, 121, 242),
				"JXLoginPanel.banner.lightBackground",
				new ColorUIResource(198, 211, 247), }));*/
	}
}
