package civvi.osgi.desktop.swingx.plaf;

import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;

import civvi.osgi.desktop.swingx.JXHeapView;
import civvi.osgi.desktop.swingx.plaf.basic.BasicHeapViewUI;

/**
 * {@link JXHeapView} component addons.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since 21st November 2007
 */
public class JXHeapViewAddon extends AbstractComponentAddon {
	/**
	 * Creates a new instance of JXHeapView
	 */
	public JXHeapViewAddon() {
		super("JXHeapView");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addBasicDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addBasicDefaults(addon, defaults);
		defaults.add(
				JXHeapView.uiClassID,
				BasicHeapViewUI.class.getName());
		UIManagerExt.addResourceBundle(
				"civvi.osgi.desktop.swingx.plaf.basic.resources.HeapView");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addMetalDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addMetalDefaults(addon, defaults);

/*		if (isPlastic()) {
			defaults.addAll(Arrays.asList(new Object[] {
					"JXLoginPanel.banner.foreground",
					new ColorUIResource(Color.WHITE),
					"JXLoginPanel.banner.darkBackground",
					new ColorUIResource(Color.GRAY),
					"JXLoginPanel.banner.lightBackground",
					new ColorUIResource(Color.LIGHT_GRAY), }));
		} else {
			defaults.addAll(Arrays.asList(new Object[] {
					"JXLoginPanel.banner.foreground",
					new ColorUIResource(255, 255, 255),
					"JXLoginPanel.banner.darkBackground",
					MetalLookAndFeel.getCurrentTheme()
							.getPrimaryControlDarkShadow(),
					"JXLoginPanel.banner.lightBackground",
					MetalLookAndFeel.getCurrentTheme().getPrimaryControl() }));
		}*/
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addWindowsDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addWindowsDefaults(addon, defaults);
	/*	defaults.addAll(Arrays.asList(new Object[] {
				"JXLoginPanel.banner.foreground",
				new ColorUIResource(255, 255, 255),
				"JXLoginPanel.banner.darkBackground",
				new ColorUIResource(49, 121, 242),
				"JXLoginPanel.banner.lightBackground",
				new ColorUIResource(198, 211, 247), }));*/
	}
}
