package civvi.osgi.desktop.swingx.plaf;

import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.UIManagerExt;

import civvi.osgi.desktop.swingx.JXWizard;

/**
 * {@link JXWizard} component addons.
 *
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since 21st November 2007
 */
public class JXWizardAddon extends AbstractComponentAddon {
	/**
	 * Creates a new instance of JXWizard
	 */
	public JXWizardAddon() {
		super("JXWizard");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addBasicDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addBasicDefaults(addon, defaults);
		defaults.add(
				JXWizard.uiClassID,
				"civvi.osgi.desktop.swingx.plaf.basic.BasicWizardUI");
		UIManagerExt.addResourceBundle(
			"civvi.osgi.desktop.swingx.plaf.basic.resources.Wizard");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addMetalDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addMetalDefaults(addon, defaults);

/*		if (isPlastic()) {
			defaults.addAll(Arrays.asList(new Object[] {
					"JXLoginPanel.banner.foreground",
					new ColorUIResource(Color.WHITE),
					"JXLoginPanel.banner.darkBackground",
					new ColorUIResource(Color.GRAY),
					"JXLoginPanel.banner.lightBackground",
					new ColorUIResource(Color.LIGHT_GRAY), }));
		} else {
			defaults.addAll(Arrays.asList(new Object[] {
					"JXLoginPanel.banner.foreground",
					new ColorUIResource(255, 255, 255),
					"JXLoginPanel.banner.darkBackground",
					MetalLookAndFeel.getCurrentTheme()
							.getPrimaryControlDarkShadow(),
					"JXLoginPanel.banner.lightBackground",
					MetalLookAndFeel.getCurrentTheme().getPrimaryControl() }));
		}*/
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected void addWindowsDefaults(
			LookAndFeelAddons addon,
			DefaultsList defaults)
	{
		super.addWindowsDefaults(addon, defaults);
	/*	defaults.addAll(Arrays.asList(new Object[] {
				"JXLoginPanel.banner.foreground",
				new ColorUIResource(255, 255, 255),
				"JXLoginPanel.banner.darkBackground",
				new ColorUIResource(49, 121, 242),
				"JXLoginPanel.banner.lightBackground",
				new ColorUIResource(198, 211, 247), }));*/
	}
}
