package civvi.osgi.desktop.swingx.plaf.basic;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

import org.jdesktop.swingx.plaf.UIManagerExt;

import civvi.osgi.desktop.swingx.JXHeapView;
import civvi.osgi.desktop.swingx.plaf.HeapViewUI;

/**
 * Default/basic UI for {@link JXHeapView}.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since 20 Nov 2007
 */
public class BasicHeapViewUI extends HeapViewUI {
	// Shared UI object
	private final static HeapViewUI heapViewUI = new BasicHeapViewUI();


	/**
	 * {@inheritDoc}
	 */
	@Override
	public void installUI(JComponent c) {
		super.installUI(c);
		//		final JXHeapView dockingPane = (JXHeapView) c;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTextFormat() {
		final String str = UIManagerExt.getString("JXHeapView.text");
		return str != null ? str : "{3,number,0.##%}";
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getToolTipFormat() {
		final String str = UIManagerExt.getString("JXHeapView.tooltip");
		return str != null ? str :
			"<html>{0,number,#.##}MB [{1,number,#.##MB} Allocated | {2,number,#.##MB} Max.]<br><i>Click to schedule Garbage Collection</i></html>";
	}


	// --- Static Methods ---

	/**
	 * Create and return instance of this UI.
	 * 
	 * @param c the component to attach to.
	 * @return an instance of this UI.
	 * @see ComponentUI#createUI(JComponent)
	 */
	public static ComponentUI createUI(JComponent c) {
		return heapViewUI;
	}
}
