package civvi.osgi.desktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.RadialGradientPaint;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;

import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

import org.jdesktop.swingx.painter.CompoundPainter;
import org.jdesktop.swingx.painter.RectanglePainter;

import civvi.osgi.desktop.swingx.JXLightTablePane;
import civvi.osgi.desktop.swingx.lighttable.Slide;
import civvi.osgi.desktop.swingx.lighttable.SlideImagePainter;
import civvi.osgi.desktop.swingx.painter.AbstractGeomAreaPainter;
import civvi.osgi.desktop.swingx.painter.RadialGradientPainter;
import civvi.osgi.desktop.swingx.plaf.LightTablePaneUI;

import com.jhlabs.image.ShadowFilter;

/**
 * TODO Type comment.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since 11 Dec 2007
 */
public class BasicLightTablePaneUI extends LightTablePaneUI {
	// Shared UI object
	private final static LightTablePaneUI lightTablePaneUI = new BasicLightTablePaneUI();

	private static final RadialGradientPainter BACKGROUND_PAINTER =
		new RadialGradientPainter(new RadialGradientPaint(
				new Point2D.Double(0.5, 0.5),
				1.0f,
				new float[] { 0.33f, 1.0f },
//				new float[] { 0.0f, 0.5f },
				new Color[] { Color.WHITE, new Color(234, 234, 220) }));
//				new Color[] { Color.WHITE, Color.BLACK }));
	

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void installUI(JComponent c) {
		super.installUI(c);

		final JXLightTablePane lightTablePane = (JXLightTablePane) c;
		lightTablePane.setLayout(new LightTableLayout());
		lightTablePane.setBackgroundPainter(BACKGROUND_PAINTER);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void decorate(Slide slide) {
		slide.setOpaque(false);
		
		ShadowFilter shadowFilter = new ShadowFilter();
		shadowFilter.setAngle(-90.0f);
		shadowFilter.setDistance(2.0f);
		shadowFilter.setRadius(2.0f);
		shadowFilter.setOpacity(0.75f);
		
		RectanglePainter rectanglePainter = new RectanglePainter(Color.WHITE, null);
		rectanglePainter.setInsets(new Insets(5, 5, 5, 5));
		rectanglePainter.setRounded(true);
		rectanglePainter.setRoundHeight(10);
		rectanglePainter.setRoundWidth(10);
		rectanglePainter.setFilters(shadowFilter);

		final SlideImagePainter imagePainter = new SlideImagePainter();
		imagePainter.setInsets(new AbstractGeomAreaPainter.Insets2D(0.1d, 0.1d, 0.1d, 0.1d));
		imagePainter.setImage(slide.getImage());
		imagePainter.setScaleToFit(true);
//		imagePainter.setFilters(new OpacityFilter(128));
		slide.addPropertyChangeListener("image", new PropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent evt) {
				imagePainter.setImage((BufferedImage) evt.getNewValue());
			}
		});

		slide.setBackgroundPainter(new CompoundPainter<JComponent>(
				rectanglePainter,
				imagePainter));
	}


	// --- Static Methods ---

	/**
	 * Create and return instance of this UI.
	 * 
	 * @param c the component to attach to.
	 * @return an instance of this UI.
	 * @see ComponentUI#createUI(JComponent)
	 */
	public static ComponentUI createUI(JComponent c) {
		return lightTablePaneUI;
	}

	/**
	 * A {@link LayoutManager} that places the components as if the person had
	 * dropped a load of photos onto the table from the centre. This is a
	 * random but constrained approach so they all emanate from the centre but
	 * try to avoid overlapping so much that some of the contents cannot be
	 * seen.
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 11 Dec 2007
	 */
	private static class LightTableLayout implements LayoutManager2 {
		private final Logger log = Logger.getLogger(getClass().getName());
		
		private final Map<Component, Point2D> pointMap;

		/**
		 * Default constructor.
		 */
		public LightTableLayout() {
			super();
			this.pointMap = new WeakHashMap<Component, Point2D>();
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void addLayoutComponent(String name, Component comp) {

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void removeLayoutComponent(Component comp) {

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Dimension preferredLayoutSize(Container parent) {
			final int ncomponents = parent.getComponentCount();
			return new Dimension(100 / ncomponents, 100 / ncomponents);
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Dimension minimumLayoutSize(Container parent) {
			final int ncomponents = parent.getComponentCount();
			return new Dimension(50 / ncomponents, 50 / ncomponents);
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void layoutContainer(Container parent) {
			synchronized (parent.getTreeLock()) {
				final Insets insets = parent.getInsets();
				final double availableWidth = parent.getWidth() - insets.left -
						insets.right;
				final double availableHeight = parent.getHeight() - insets.top -
						insets.bottom;

				final int ncomponents = parent.getComponentCount();

				final double scaleRatio = 1 / ((double) ncomponents / 4);

				// final Point screenCenter = new Point(parent.getWidth() / 2,
				// parent.getHeight() / 2);
				for (int i = 0; i < ncomponents; i++) {
					final Component child = parent.getComponent(i);
					// final Point childCenter = centerMap.get(child);

					Point2D point = this.pointMap.get(child);
					// no position? then calculate
					if (point == null) {

						// final double diameter = calcDiameter(child, parent);

						if (i == 0) {
							// first component always goes near the others
							point = new Point2D.Double(
									0.5 - child.getWidth() / 2,
									0.5 - child.getHeight() / 2);
						} else {
							point = calcPosition(child, parent, scaleRatio);
						}

						this.pointMap.put(child, point);
					}

					// calculate scaling from originally calculated ellipse
					// width
					final int size = (int) (scaleRatio * (availableHeight < availableWidth ? availableWidth : availableHeight)); 
					child.setBounds(
							(int) (availableWidth * (point.getX() - scaleRatio / 2)) + insets.left,
							(int) (availableHeight * (point.getY() - scaleRatio / 2)) + insets.top,
							size, size);
				}
			}
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void addLayoutComponent(Component comp, Object constraints) {

		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public Dimension maximumLayoutSize(Container target) {
			return null;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public float getLayoutAlignmentX(Container target) {
			return 0;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public float getLayoutAlignmentY(Container target) {
			return 0;
		}

		/**
		 * {@inheritDoc}
		 */
		@Override
		public void invalidateLayout(Container target) {

		}

		/**
		 * 
		 * TODO Method comment.
		 * 
		 * @param comp
		 * @param parent
		 * @return
		 */
		private Point2D calcPosition(Component comp, Container parent, double scaleRatio) {
			Point2D randCompPoint = null;

			while (randCompPoint == null) {
				final Component randComp = parent.getComponent((int) (Math
						.random()
						* parent.getComponentCount() / 3));
				randCompPoint = this.pointMap.get(randComp);
			}

//			final double maxDist = 0.35;
//			final double minDist = scaleRatio / 2;
//			final double dist = (maxDist - minDist) * Math.random() + minDist;

			int count = 0;
			while (count < 50) {
//				final double angle = Math.random() * 2 * Math.PI; // from
				// vertical
				// final double angle = Math.toRadians(0);

				final Point2D point = new Point2D.Double(Math.random(), Math.random());
						
//						calcX(randCompPoint.getX(), angle, dist),
//						calcY(randCompPoint.getY(), angle, dist));

				if (!doesIntersect(point, parent, scaleRatio) 
						&& point.getX() >= 0 && point.getX() <= 1 
						&& point.getY() >= 0 && point.getY() <= 1)
				{
					return new Point2D.Double(
							point.getX() - comp.getWidth() / 2,
							point.getY() - comp.getHeight() / 2);
				}
				count++;
			}
			log.warning("Could not position!");
			return new Point2D.Double(0, 0);
		}

		/**
		 * 
		 * TODO Method comment.
		 * 
		 * @param point
		 * @param parent
		 * @return
		 */
		private boolean doesIntersect(Point2D point, Container parent, double scaleRatio) {
			for (int i = 0; i < parent.getComponentCount(); i++) {
				final Component comp = parent.getComponent(i);

				final Point2D compPoint = pointMap.get(comp);

				if (compPoint == null)
					continue;

				final Ellipse2D compEllipse = new Ellipse2D.Double(
						compPoint.getX() - scaleRatio / 2,
						compPoint.getY() - scaleRatio / 2,
						scaleRatio,
						scaleRatio);

				if (compEllipse.contains(point)) {
					log.warning("Point intercets = Point2D [x=" + point.getX()
							+ ",y=" + point.getY() + "] Ellipse2D [x="
							+ compEllipse.getX() + ",y=" + compEllipse.getY() + ",w="
							+ compEllipse.getWidth() + ",y=" + compEllipse.getHeight()
							+ "]");
					return true;
				}
			}
			return false;
		}

		/**
		 * 
		 * TODO Method comment.
		 * 
		 * @param x
		 * @param a
		 * @param dist
		 * @return
		 */
		@SuppressWarnings("unused")
		private static double calcX(double x, double a, double dist) {
			return x + Math.sin(a) * dist;
		}

		/**
		 * 
		 * TODO Method comment.
		 * 
		 * @param y
		 * @param a
		 * @param dist
		 * @return
		 */
		@SuppressWarnings("unused")
		private static double calcY(double y, double a, double dist) {
			return y + Math.cos(a) * dist;
		}

		/**
		 * 
		 * TODO Method comment.
		 * 
		 * @param comp
		 * @param parent
		 * @return
		 */
		@SuppressWarnings("unused")
		private static double calcDiameter(Component comp, Container parent) {
			final double width = comp.getPreferredSize().getWidth()
			/ parent.getWidth();
			final double height = comp.getPreferredSize().getHeight()
			/ parent.getHeight();

			return Math.sqrt(Math.pow(width, 2) + Math.pow(height, 2));
		}
	}
}
