package civvi.osgi.desktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.plaf.ComponentUI;

import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.UIManagerExt;

import civvi.osgi.desktop.swingx.JXWizard;
import civvi.osgi.desktop.swingx.plaf.WizardUI;
import civvi.osgi.desktop.swingx.wizard.StepPanel;

/**
 * Default/basic UI for {@link JXWizard}.
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since 20 Nov 2007
 */
public class BasicWizardUI extends WizardUI {
	// Shared UI object
	private final static WizardUI wizardUI = new BasicWizardUI();
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void installUI(final JComponent c) {
		super.installUI(c);
		
		final JXWizard wizard = (JXWizard) c;
		
		c.setLayout(new BorderLayout());
		c.addPropertyChangeListener("stepPanel", new PropertyChangeListener() {
			@Override
			public void propertyChange(PropertyChangeEvent evt) {
				if (evt.getOldValue() != null) {
					c.remove((StepPanel) evt.getOldValue());
				}
				c.add((StepPanel) evt.getNewValue(), BorderLayout.CENTER);
				c.revalidate();
				c.repaint();
			}
		});
		
		final JXPanel southPanel = new JXPanel(new BorderLayout());
		southPanel.add(new JSeparator(), BorderLayout.NORTH);
		final JXPanel buttonPanel = new JXPanel(new FlowLayout(FlowLayout.TRAILING));
		
		addButtons(
				buttonPanel,
				wizard.getPrevAction(),
				wizard.getNextAction(),
				wizard.getFinishAction(),
				wizard.getCancelAction());
		southPanel.add(buttonPanel, BorderLayout.CENTER);
		c.add(southPanel, BorderLayout.SOUTH);
		c.setPreferredSize(new Dimension(400, 350));
	}

	/**
	 * 
	 * TODO
	 *
	 * @param panel
	 * @param actions
	 */
	private void addButtons(JXPanel panel, Action... actions) {
		final JButton[] buttons = new JButton[actions.length];
		
		int buttonWidth = 0;
		
		for (int i = 0; i < actions.length; i++) {
			buttons[i] = new JButton(actions[i]);
			panel.add(buttons[i]);
			if (buttons[i].getPreferredSize().width > buttonWidth) {
				buttonWidth = buttons[i].getPreferredSize().width;
			}
		}

		for (JButton button : buttons) {
			button.setSize(buttonWidth, button.getHeight());
		}
	}

	/**
	 * {@inheritDoc}
	 */
//	@Override
	public String getTextFormat() {
		return UIManagerExt.getString("JXWizard.text");
	}

	/**
	 * {@inheritDoc}
	 */
//	@Override
	public String getToolTipFormat() {
		return UIManagerExt.getString("JXWizard.tooltip");
	}


	// --- Static Methods ---

	/**
	 * Create and return instance of this UI.
	 * 
	 * @param c the component to attach to.
	 * @return an instance of this UI.
	 * @see ComponentUI#createUI(JComponent)
	 */
	public static ComponentUI createUI(JComponent c) {
		return wizardUI;
	}
}
