package civvi.osgi.desktop.swingx.wizard;

import java.util.HashMap;
import java.util.Map;

import javax.swing.event.EventListenerList;

/**
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [23 May 2010]
 * @param <S>
 */
public abstract class AbstractWizardModel<S>
implements WizardModel<S>
{
	protected EventListenerList listenerList = new EventListenerList();

	protected Map<String, Object> data = new HashMap<String, Object>();
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	@SuppressWarnings("unchecked")
	public S getStep() {
		return (S) getValue("step");
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void setStep(S step) {
		putValue("step", step);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getValue(Object key) {
		return this.data.get(key);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void putValue(String key, Object value) {
		final Object oldValue = this.data.put(key, value);
		if (oldValue != null && value != null && oldValue.equals(value)) {
		    return;
		}
		fire(key, oldValue, getStep());
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean containsValue(String key) {
		return getValue(key) != null;
	}
	
	/**
	 * 
	 * TODO
	 *
	 * @param previous
	 * @param next
	 */
	public void fire(String name, Object previous, Object next) {
		fire(new WizardModelEvent(this, name, previous, next));
	}
	
	/**
	 * 
	 * TODO
	 *
	 * @param e
	 */
	public void fire(WizardModelEvent e) {
		// Guaranteed to return a non-null array
		WizardModelListener[] listeners = this.listenerList.getListeners(
				WizardModelListener.class);
		// Process the listeners last to first, notifying
		// those that are interested in this event
		for (int i = listeners.length - 1; i>=0; i--) {
			listeners[i].wizardChanged(e);
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addListener(WizardModelListener listener) {
		this.listenerList.add(WizardModelListener.class, listener);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void removeListener(WizardModelListener listener) {
		this.listenerList.remove(WizardModelListener.class, listener);
	}
}
