package civvi.osgi.desktop.swingx.wizard;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

/**
 * 
 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [23 May 2010]
 * @param <M>
 */
public class DefaultController<M extends WizardModel<?>>
implements StepController<M>
{
	protected final Map<Object, Class<? extends StepPanel>> stepMap;
	private final Map<Object, StepPanel> cache = new WeakHashMap<Object, StepPanel>();
	protected final Object[] stepIds;
	
	/**
	 * 
	 * TODO
	 * 
	 * @param stepIds
	 */
	public DefaultController(Object... stepIds) {
		this(new HashMap<Object, Class<? extends StepPanel>>(), stepIds);
	}

	/**
	 * 
	 * TODO
	 * 
	 * @param stepMap
	 * @param stepIds
	 */
	public DefaultController(
			Map<Object, Class<? extends StepPanel>> stepMap,
			Object... stepIds) {
		this.stepMap = stepMap;
		this.stepIds = stepIds;
	}

	/**
	 * 
	 * TODO
	 *
	 * @param stepId
	 * @param model
	 * @return
	 */
	public Class<? extends StepPanel> getClass(Object stepId, M model) {
		return stepMap.get(stepId);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public StepPanel getPanel(Object stepId, M model) {
		StepPanel panel = cache.get(stepId);

		if (panel == null && getClass(stepId, model) != null) {
			try {
				panel = getClass(stepId, model).newInstance();
			} catch (InstantiationException ie) {
				throw new RuntimeException(
						"Model must have a no args constructor. Use #show(T model).",
						ie);
			} catch (IllegalAccessException iae) {
				throw new RuntimeException(
						"Model must have a no args constructor. Use #show(T model).",
						iae);
			}
			cache.put(stepId, panel);
		}

		return panel;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public boolean isFinishable(Object stepId, M model) {
		return indexOfStep(stepId, model) == stepCount(model) - 1;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int indexOfStep(Object stepId, M model) {
		for (int i = 0; i < stepCount(model); i++) {
			if (getStepIds(model)[i].equals(stepId)) {
				return i;
			}
		}
		return -1;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public int stepCount(M model) {
		return getStepIds(model).length;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object getStepId(int index, M model) {
		return getStepIds(model)[index];
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Object[] getStepIds(M model) {
		return this.stepIds;
	}
	
	/**
	 * {@inheritDoc}
	 */
	@Override
	public void cancel(M model) {
		
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void finish(M model) {
		
	}
}
