package civvi.osgi.desktop.view;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.ActionProvider;
import civvi.osgi.desktop.swingx.AppFrameworkSupport;
import civvi.osgi.desktop.swingx.docking.AbstractDockable;

/**
 * Defines a view within the desktop.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [24th July 2008]
 */
public abstract class AbstractView extends AbstractDockable
implements ActionProvider
{
	private static final long serialVersionUID = 4043298682203438060L;

	/** Resource Key: name */
	public static final String NAME = "name";
	/** Resource Key: name */
	public static final String DESCRIPTION = "description";
	/** Resource Key: Small Icon */
	public static final String SMALL_ICON_KEY = "icon.small";
	/** Resource Key: Large Icon */
	public static final String LARGE_ICON_KEY = "icon.large";

	protected final AppFrameworkSupport<OSGiDesktop> support;

	/**
	 * 
	 * TODO
	 * @param id
	 */
    protected AbstractView(String id) {
        super(id, null);
        this.support = new AppFrameworkSupport<OSGiDesktop>(this);
        setBorder(BorderFactory.createEmptyBorder(2, 3, 4, 4)); // L&F bug
		// populate from resources.
        setTitle(this.support.getString(NAME));
        setTooltip(this.support.getString(DESCRIPTION));
        setSmallIcon(this.support.getIcon(SMALL_ICON_KEY));
        setLargeIcon(this.support.getIcon(LARGE_ICON_KEY));
        
        // sync action map with known Actions
        final ActionMap actionMap = this.support.getActionMap();
        for (Object key : actionMap.keys() != null ? actionMap.keys() : new String[0]) {
        	getActionMap().put(key, this.support.getAction(key));
        }
    }

    @Override
    public Action getAction(String actionKey, boolean createEmpty) {
    	return this.support.getAction(actionKey, createEmpty);
    }
}
