package civvi.osgi.desktop.view;

import civvi.osgi.desktop.swingx.JXDockingPane.DefaultDockFactory;
import civvi.osgi.desktop.swingx.docking.AbstractDock;
import civvi.osgi.desktop.swingx.docking.AbstractDockable;
import civvi.osgi.desktop.swingx.docking.DockFactory;

/**
 * A {@link DockFactory} for the desktop. This gives two distinct different
 * versions of a dock: one editor pane and multiple general purpose docks.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [14 Apr 2009]
 */
public class DesktopDockFactory extends DefaultDockFactory {
	/**
	 * {@inheritDoc}
	 */
	@Override
	public AbstractDock create(String position) {
		return position.equals("default") ? new EditorDock() : new DefaultDock();
	}


	// --- Inner Classes ---

	/**
	 * A dock specifically for {@link AbstractEditorView}s.
	 * 
	 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 14 Apr 2009
	 */
	public static class EditorDock extends AbstractDock {
		private static final long serialVersionUID = -1751531729084665853L;

		private static volatile boolean CREATED = false;

		/**
		 * Create a new {@link EditorDock}
		 * 
		 * @throws IllegalStateException if more than one dock of this type is
		 * created in this JVM instance.
		 */
		public EditorDock() {
			if (CREATED) { // prevent more than one!
				throw new IllegalStateException(
						"Only one editor dock can exist [at the moment]!");
			}
			CREATED = true;
		}

		@Override
		public boolean isDockable(AbstractDockable dockable) {
			return dockable instanceof AbstractEditorView;
		}
	}

	/**
	 * A default dock. This is the multi-purpose dock where everything but
	 * {@link AbstractEditorView}s can appear.
	 * 
	 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
	 * @since v1.0.0 [14 Apr 2009]
	 */
	private static class DefaultDock extends AbstractDock {
		private static final long serialVersionUID = 1L;

		@Override
		public boolean isDockable(AbstractDockable dockable) {
			return !(dockable instanceof AbstractEditorView);
		};
	}
}
