package civvi.osgi.desktop.view;


import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

import civvi.osgi.desktop.DesktopService;
import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.docking.AbstractDockable;
import civvi.osgi.desktop.swingx.docking.DockManager.DefaultDockableFactory;

/**
 * 
 * TODO
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 24th July 2008
 */
public class DesktopViewFactory extends DefaultDockableFactory {
	private final OSGiDesktop desktop;

	/**
	 * 
	 * TODO
	 * 
	 * @param activator
	 */
	public DesktopViewFactory(OSGiDesktop desktop) {
		this.desktop = desktop;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Class<? extends AbstractDockable> getClass(Object key) {
		final Class<? extends AbstractDockable> type =
			this.desktop.getActivator().getServiceManager().getViewType(key);
		
		return type;
//		if (key instanceof Editable) {
//			return this.desktop.getActivator().getServiceManager().getViewType(key);
//		}
//		return (Class<? extends AbstractDockable>) key;
	}

	/**
	 * 
	 * TODO
	 * @param cls
	 * @return
	 */
	private DesktopService<?> getDesktopServiceForView(final Class<? extends AbstractDockable> cls) {
		return this.desktop.getActivator().getServiceManager().getServiceForView(cls);
	}
	
	/**
     * {@inheritDoc}
     */
    @Override
    public AbstractDockable create(Object key) {
        try {
        	final Class<? extends AbstractDockable> cls = getClass(key);
        	
        	try {
        		final Constructor<? extends AbstractDockable> cons = cls.getConstructor(new Class[0]);
        		return cons.newInstance();
        	} catch (NoSuchMethodException e) {
        		DesktopService<?> service = getDesktopServiceForView(cls);
        		final Constructor<? extends AbstractDockable> cons = cls.getConstructor(service.getClass());
        		return cons.newInstance(service);
        	}
        } catch (InstantiationException ie) {
        	throw new IllegalArgumentException(String.format(
	        		"Unable to instantiate dockable! [key=%1$s]",
	        		key), ie);
        } catch (IllegalAccessException iae) {
        	throw new IllegalArgumentException(String.format(
	        		"Unable to access dockable class! [key=%1$s]",
	        		key), iae);
        } catch (NoSuchMethodException nsme) {
        	throw new IllegalArgumentException(String.format(
	        		"Unable to locate suitable constructor! [key=%1$s]",
	        		key), nsme);
        } catch (InvocationTargetException ite) {
        	throw new IllegalArgumentException(String.format(
	        		"Unable to invoke constructor! [key=%1$s]",
	        		key), ite);
        }
    }
}
