package civvi.osgi.desktop.view.error;

import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Level;

import javax.swing.JOptionPane;
import javax.swing.JScrollPane;

import org.jdesktop.application.Action;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.JXList;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.ShadingColorHighlighter;
import org.jdesktop.swingx.error.ErrorInfo;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.GenericListModel;
import civvi.osgi.desktop.view.AbstractView;

public class ErrorView extends AbstractView {
	private static final long serialVersionUID = 1L;

	private final OSGiDesktop desktop;
	private final JXList list;
	private final GenericListModel<ErrorInfo> model;
	
	private boolean errorsSelected;

	/**
	 * 
	 * TODO
	 * @param desktop
	 */
	public ErrorView(OSGiDesktop desktop) {
		super("error");
		this.desktop = desktop;

		this.list = new JXList();
		this.list.setPreferredSize(new Dimension(350, 50));
		this.list.setCellRenderer(new ErrorInfoCellRenderer());
		this.list.setModel(this.model = new GenericListModel<ErrorInfo>());
		this.list.setPrototypeCellValue(new ErrorInfo(
				"Prototype Error",
				"Prototype Error Prototype Error Prototype Error",
				"Prototype Error Prototype Error Prototype Error",
				"Prototype Error",
				null,
				Level.SEVERE,
				null));
		this.list.addMouseListener(new MouseHandler());
		this.list.setHighlighters(
				new ShadingColorHighlighter(
						new HighlightPredicate.RowGroupHighlightPredicate(1)));
		setContent(new JScrollPane(this.list));

		this.model.set(this.desktop.getErrorList());
	}
	
	public boolean isErrorsSelected() {
		return errorsSelected;
	}
	
	public void setErrorsSelected(boolean errorsSelected) {
		final boolean oldValue = this.errorsSelected;
		this.errorsSelected = errorsSelected;
		firePropertyChange("errorsSelected", oldValue, this.errorsSelected);
	}

	/**
	 * 
	 * TODO
	 */
	@Action(enabledProperty = "errorsSelected")
	public void showError() {
		final int index = this.list.getSelectedIndex();
		final ErrorInfo errorInfo = this.model.get(index);
		JXErrorPane.showFrame(this, errorInfo);
	}

	/**
	 * 
	 * TODO
	 */
	@Action(enabledProperty = "errorsExist")
	public void clearErrors() {
		final int result = JOptionPane.showConfirmDialog(
				this,
				"TODO Are you sure you want to clear the error list? This cannot be undone.",
				"Confirm Clear",
				JOptionPane.OK_CANCEL_OPTION);
		if (result == JOptionPane.OK_OPTION) {
			this.desktop.getErrorList().clear();
		}
	}
	
	
	private class MouseHandler extends MouseAdapter {
		@Override
		public void mouseClicked(MouseEvent e) {
			if (e.getClickCount() > 1) {
				showError();
			}
		}
	}
}
