package civvi.osgi.desktop.view.log;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import org.jdesktop.swingx.JXPanel;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogService;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.AppFrameworkSupport;
import civvi.osgi.desktop.swingx.SwingUtil;

/**
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v?.?.? [24 Sep 2010]
 */
public class LogEntryCellRenderer extends JXPanel
implements ListCellRenderer
{
	private static final long serialVersionUID = -3941178117583144163L;
	/*
	 * An empty <code>Border</code>. This field might not be used. To change the
	 * <code>Border</code> used by this renderer override the 
	 * <code>getListCellRendererComponent</code> method and set the border
	 * of the returned component directly.
	 */
	private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
	private static final Border DEFAULT_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
	protected static Border noFocusBorder = DEFAULT_NO_FOCUS_BORDER;

	private final AppFrameworkSupport<OSGiDesktop> support;

	private final JLabel levelLabel;
	private final JLabel messageLabel;
//	private final JLabel statusLabel;

	/**
	 * Constructs a default renderer object for an item
	 * in a list.
	 */
	public LogEntryCellRenderer() {
		super();
		this.support = new AppFrameworkSupport<OSGiDesktop>(this);
		setOpaque(true);
		setBorder(getNoFocusBorder());
		setName("List.cellRenderer");
		
		final GroupLayout layout = new GroupLayout(this);
		setLayout(layout);
		
		this.levelLabel = new JLabel();
		this.messageLabel = new JLabel();
//		this.statusLabel = new JLabel();
		
		layout.setHorizontalGroup(
				layout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
						.addGap(3, 3, 3)
						.addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING)
								.addComponent(levelLabel, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE, Short.MAX_VALUE)
								.addComponent(messageLabel, GroupLayout.Alignment.LEADING, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE, Short.MAX_VALUE))
								.addGap(3, 3, 3))
		);
		layout.setVerticalGroup(
				layout.createParallelGroup(GroupLayout.Alignment.LEADING)
				.addGroup(layout.createSequentialGroup()
						.addGap(3, 3, 3)
						.addComponent(levelLabel)
						.addGap(3, 3, 3)
						.addComponent(messageLabel, GroupLayout.DEFAULT_SIZE, GroupLayout.PREFERRED_SIZE, Short.MAX_VALUE)
						.addGap(3, 3, 3))
		);
	}

	/**
	 * 
	 * TODO
	 *
	 * @return
	 */
	private Border getNoFocusBorder() {
		Border border = UIManager.getBorder("List.cellNoFocusBorder");
		if (System.getSecurityManager() != null) {
			if (border != null) return border;
			return SAFE_NO_FOCUS_BORDER;
		} else {
			if (border != null &&
					(noFocusBorder == null ||
							noFocusBorder == DEFAULT_NO_FOCUS_BORDER)) {
				return border;
			}
			return noFocusBorder;
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public Component getListCellRendererComponent(
			JList list,
			Object value,
			int index,
			boolean isSelected,
			boolean cellHasFocus)
	{
		setComponentOrientation(list.getComponentOrientation());

		Color bg = null;
		Color fg = null;

		JList.DropLocation dropLocation = list.getDropLocation();
		if (dropLocation != null
				&& !dropLocation.isInsert()
				&& dropLocation.getIndex() == index) {

			bg = UIManager.getColor("List.dropCellBackground");
			fg = UIManager.getColor("List.dropCellForeground");

			isSelected = true;
		}

		if (isSelected) {
			setBackground(bg == null ? list.getSelectionBackground() : bg);
			setForeground(fg == null ? list.getSelectionForeground() : fg);
		} else {
			setBackground(list.getBackground());
			setForeground(list.getForeground());
		}
		this.levelLabel.setBackground(getBackground());
		this.messageLabel.setBackground(getBackground());
		this.levelLabel.setForeground(getForeground());
		this.messageLabel.setForeground(SwingUtil.alpha(getForeground(), .5f));
		
		setEnabled(list.isEnabled());
		this.levelLabel.setEnabled(isEnabled());
		this.messageLabel.setEnabled(isEnabled());
		
		setFont(list.getFont());
		this.levelLabel.setFont(getFont().deriveFont(11.0f).deriveFont(Font.BOLD));
		this.messageLabel.setFont(getFont());
		
		decorate((LogEntry) value);
		
		Border border = null;
		if (cellHasFocus) {
			if (isSelected) {
				border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
			}
			if (border == null) {
				border = UIManager.getBorder("List.focusCellHighlightBorder");
			}
		} else {
			border = getNoFocusBorder();
		}
		setBorder(border);

		return this;
	}

	/**
	 * TODO
	 *
	 * @param entry
	 */
	private void decorate(LogEntry entry) {
		final String level = toLevelString(entry.getLevel());
		this.levelLabel.setText(this.support.getString(level + ".level.title"));
		this.levelLabel.setIcon(this.support.getIcon(level + ".level.icon"));
		this.messageLabel.setText(entry.getMessage());
//		this.statusLabel.setText(entry.isStarted() ? "Running..." : "Queued");
	}

	/**
	 *
	 * @param level
	 */
	private String toLevelString(int level) {
		switch (level) {
		case LogService.LOG_ERROR:
			return "ERROR";
		case LogService.LOG_WARNING:
			return  "WARNING";
		case LogService.LOG_INFO:
			return  "INFO";
		case LogService.LOG_DEBUG:
			return  "DEBUG";
		}
		throw new IllegalArgumentException("Unknown level! [" + level + "]");
	}
}
