package civvi.osgi.desktop.view.properties;

import java.util.Map.Entry;

import javax.swing.table.TableModel;

import civvi.osgi.desktop.swingx.AbstractListTableModel;

/**
 * A {@link TableModel} that displays key/value pairs.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 15 Aug 2008
 * @param <K>
 * @param <V>
 */
public class PropertiesTableModel<K, V>
extends AbstractListTableModel<Entry<K, V>, PropsColumn>
{
	private static final long serialVersionUID = 1L;

	@Override
	protected Object getValueAt(Entry<K,V> row, PropsColumn column) {
		switch (column) {
		case KEY:
			return row.getKey();
		case VALUE:
			return row.getValue();
		default:
			throw new IllegalArgumentException(String.format(
					"Unknown column index! [columnIndex=%1$d]",
					column));
		}
	}
}
