package civvi.osgi.desktop.view.properties;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.JScrollPane;

import org.jdesktop.swingx.JXTable;

import civvi.osgi.desktop.view.AbstractView;

/**
 * A view for inspecting properties of an item.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since 23 Mar 2009
 */
public class PropertiesView extends AbstractView {
	private static final long serialVersionUID = -5256086138833593650L;

	private final JXTable table;
	private final PropertiesTableModel<String, Object> tableModel;
	private Object bean;

	/**
	 * 
	 * TODO
	 *
	 */
	public PropertiesView() {
		super("properties");
		this.tableModel = new PropertiesTableModel<String, Object>();
		this.table = new JXTable(this.tableModel);
		this.table.setPreferredSize(new Dimension(350, 50));
		setContent(new JScrollPane(this.table));
		addPropertyChangeListener("bean", new BeanChangeHandler());
	}

	/**
	 * @return the bean.
	 */
	public Object getBean() {
		return bean;
	}

	/**
	 * @param bean the bean to set.
	 */
	public void setBean(Object bean) {
		final Object oldValue = getBean();
		this.bean = bean;
		firePropertyChange("bean", oldValue, getBean());
	}


	// --- Inner Classes

	/**
	 * 
	 * TODO
	 * 
	 * @author <a href="mailto:dansiviter@gmail.com">Daniel Siviter</a>
	 * @since 23 Mar 2009
	 */
	private class BeanChangeHandler implements PropertyChangeListener {
		@Override
		public void propertyChange(PropertyChangeEvent evt) {
//			final Object bean = evt.getNewValue();
//			tableModel.set(inspector.getProperties().entrySet());
		}
	}
}
