package civvi.osgi.desktop.view.properties;

import civvi.osgi.desktop.OSGiDesktop;
import civvi.osgi.desktop.swingx.AppFrameworkSupport;
import civvi.osgi.desktop.swingx.Column;

/**
 * Defines a column within the for the {@link PropertiesTableModel}.
 * 
 * @author <a href="mailto=dansiviter@gmail.com">Daniel Siviter</a>
 * @since v1.0.0 [15 Aug 2008]
 */
public enum PropsColumn implements Column {
	KEY(String.class),
	VALUE(String.class);
	
	private final AppFrameworkSupport<OSGiDesktop> support;
	final Class<?> type;
	private PropsColumn(Class<?> type) {
		this.support = new AppFrameworkSupport<OSGiDesktop>(this);
		this.type = type;
	}
	@Override
	public Class<?> getType() {
		return this.type;
	}
	@Override
	public String getDisplayName() {
		return this.support.getString("column." + name() + ".name");
	}
}